<!DOCTYPE html>
<html>
<head>
    <title>Village Test</title>
</head>
<body>
    <h2>Test Village Selection</h2>
    
    <form data-location-form>
        <label>Province: 
            <select data-role="province" data-endpoint="/api/provinces/:id/districts">
                <option value="">Select Province</option>
                <?php
                $provinces = \App\Models\Province::orderBy('name')->get();
                foreach($provinces as $province) {
                    echo "<option value='{$province->id}'>{$province->name}</option>";
                }
                ?>
            </select>
        </label><br><br>
        
        <label>District: 
            <select data-role="district" data-endpoint="/api/districts/:id/communes" disabled>
                <option value="">Select District</option>
            </select>
        </label><br><br>
        
        <label>Commune: 
            <select data-role="commune" data-endpoint="/api/communes/:id/villages" disabled>
                <option value="">Select Commune</option>
            </select>
        </label><br><br>
        
        <label>Village: 
            <select data-role="village" disabled>
                <option value="">Select Village</option>
            </select>
        </label>
    </form>
    
    <script>
    (function() {
        function initLocationSelects() {
            const form = document.querySelector('form[data-location-form]');
            if (!form) return;
            
            const provinceSelect = form.querySelector('[data-role="province"]');
            const districtSelect = form.querySelector('[data-role="district"]');
            const communeSelect = form.querySelector('[data-role="commune"]');
            const villageSelect = form.querySelector('[data-role="village"]');
            
            async function loadOptions(select, url) {
                if (!select || !url) return;
                
                select.disabled = true;
                select.innerHTML = '<option value="">Loading...</option>';
                
                try {
                    console.log('Fetching:', url);
                    const response = await fetch(url);
                    const data = await response.json();
                    console.log('Data:', data);
                    
                    const items = data.data || [];
                    select.innerHTML = '<option value="">Select</option>';
                    
                    items.forEach(item => {
                        const option = document.createElement('option');
                        option.value = item.id;
                        option.textContent = item.name;
                        select.appendChild(option);
                    });
                    
                    select.disabled = false;
                } catch (error) {
                    console.error('Error:', error);
                    select.innerHTML = '<option value="">Error loading</option>';
                    select.disabled = true;
                }
            }
            
            function resetSelect(select) {
                if (!select) return;
                select.innerHTML = '<option value="">Select</option>';
                select.disabled = true;
            }
            
            if (provinceSelect && districtSelect) {
                provinceSelect.addEventListener('change', function() {
                    const value = this.value;
                    resetSelect(communeSelect);
                    resetSelect(villageSelect);
                    
                    if (value) {
                        loadOptions(districtSelect, `/api/provinces/${value}/districts`);
                    } else {
                        resetSelect(districtSelect);
                    }
                });
            }
            
            if (districtSelect && communeSelect) {
                districtSelect.addEventListener('change', function() {
                    const value = this.value;
                    resetSelect(villageSelect);
                    
                    if (value) {
                        loadOptions(communeSelect, `/api/districts/${value}/communes`);
                    } else {
                        resetSelect(communeSelect);
                    }
                });
            }
            
            if (communeSelect && villageSelect) {
                communeSelect.addEventListener('change', function() {
                    const value = this.value;
                    
                    if (value) {
                        loadOptions(villageSelect, `/api/communes/${value}/villages`);
                    } else {
                        resetSelect(villageSelect);
                    }
                });
            }
        }
        
        document.addEventListener('DOMContentLoaded', initLocationSelects);
    })();
    </script>
</body>
</html>
