<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

echo "Checking users in database...\n";

$users = App\Models\UserModel::all();
echo "Total users: " . $users->count() . "\n";

foreach ($users as $user) {
    echo "ID: {$user->id}, Name: {$user->name}, Role: {$user->role}\n";
}

echo "\nChecking session data...\n";
session_start();
echo "Session user_id: " . (session()->has('user_id') ? session('user_id') : 'Not set') . "\n";
