<?php $__env->startSection('content'); ?>
    <div class="page" style="max-width: 1200px; margin: 0 auto;">
        <section class="form-section" id="register">
            <?php
                $selectedProvince = old('province_id', $userinfo->province_id ?? null);
                $selectedDistrict = old('district_id', $userinfo->district_id ?? null);
                $selectedCommune = old('commune_id', $userinfo->commune_id ?? null);
            ?>
            <form class="register-form" data-location-form
                action="<?php echo e(isset($userinfo) && $userinfo->exists ? route('userinfo.edit', $userinfo->id) : route('userinfo.create')); ?>"
                method="post" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php if(isset($userinfo) && $userinfo->exists): ?> <?php echo method_field('Post'); ?> <?php endif; ?>

                <article class="student-card">
                    <div class="card-header">
                        <div>
                            <h3>សូមបំពេញព័ត៌មានរបស់អ្នក</h3>
                        </div>
                        <span class="status-pill">សកម្ម</span>
                    </div>

                    <div class="fieldset">
                        <div class="fieldset-title">
                            <h4>ព័ត៌មានផ្ទាល់ខ្លួន</h4>
                            <p>អត្តសញ្ញាណ និងព័ត៌មានផ្ទាល់ខ្លួនទាំងអស់</p>
                        </div>
                        <div class="field-grid">
                            <label class="field">
                                <span>អត្តលេខ (ID Number) *</span>
                                <input type="text" name="id_number" value="<?php echo e(old('id_number', $userinfo->id_number ?? '')); ?>"
                                    placeholder="012345" required>
                            </label>
                            <label class="field">
                                <span>ឈ្មោះ (អក្សរខ្មែរ) *</span>
                                <input type="text" name="name_kh" value="<?php echo e(old('name_kh', $userinfo->name_kh ?? '')); ?>"
                                    placeholder="ឧ. សុវណ្ណុ" required>
                            </label>
                            <label class="field">
                                <span>ឈ្មោះ (អក្សរឡាតាំង) *</span>
                                <input type="text" name="name_en" value="<?php echo e(old('name_en', $userinfo->name_en ?? '')); ?>"
                                    placeholder="Sovannou" required>
                            </label>

                            <label class="field radio-field">
                                <span>ភិក្ខុ/សាមណេរ</span>
                                <div class="radio-group">
                                    <?php $__currentLoopData = $monkTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $monkType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <label class="radio-pill">
                                            <input type="radio" name="monk_type_id" value="<?php echo e($monkType->id); ?>"
                                                <?php echo e(old('monk_type_id', $userinfo->monk_type_id ?? '') == $monkType->id ? 'checked' : ''); ?>>
                                            <span><?php echo e($monkType->name); ?></span>
                                        </label>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </label>

                            <?php
                                $dobValue = old('dob', optional($userinfo)->dob ? \Illuminate\Support\Carbon::parse($userinfo->dob)->format('Y-m-d') : null);
                            ?>
                            <label class="field">
                                <span>ថ្ងៃខែឆ្នាំកំណើត *</span>
                                <?php echo $__env->make('admin.components.khmer-date-picker-separate', [
                                    'name' => 'dob',
                                    'value' => $dobValue,
                                    'required' => true
                                ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            </label>
                        </div>
                    </div>

                    <div class="fieldset">
                        <div class="fieldset-title">
                            <h4>ទីកន្លែងកំណើត</h4>
                            <p>សូមបំពេញរាយនាមតាមលំដាប់រដ្ឋបាល</p>
                        </div>
                        <div class="field-grid">
                            <label class="field">
                                <span>ខេត្ត/ក្រុង</span>
                                <select name="province_id" data-role="province" data-placeholder="ជ្រើសរើសខេត្ត">
                                    <option value=""><?php echo e(__('ជ្រើសរើសខេត្ត')); ?></option>
                                    <?php $__currentLoopData = $provinces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $province): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($province->id); ?>"
                                            <?php echo e($selectedProvince == $province->id ? 'selected' : ''); ?>>
                                            <?php echo e($province->name ?? $province->name_kh ?? $province->name_en); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </label>
                            <label class="field">
                                <span>ស្រុក/ខណ្ឌ</span>
                                <select name="district_id" data-role="district"
                                    data-endpoint="<?php echo e(url('/locations/provinces/:id/districts')); ?>"
                                    data-placeholder="ជ្រើសរើសស្រុក"
                                    data-disabled-placeholder="សូមជ្រើសខេត្តជាមុន"
                                    <?php echo e($selectedProvince ? '' : 'disabled'); ?>>
                                    <option value="">
                                        <?php echo e($selectedProvince ? 'ជ្រើសរើសស្រុក' : 'សូមជ្រើសខេត្តជាមុន'); ?>

                                    </option>
                                    <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($district->id); ?>"
                                            <?php echo e($selectedDistrict == $district->id ? 'selected' : ''); ?>>
                                            <?php echo e($district->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </label>
                            <label class="field">
                                <span>ឃុំ/សង្កាត់</span>
                                <select name="commune_id" data-role="commune"
                                    data-endpoint="<?php echo e(url('/locations/districts/:id/communes')); ?>"
                                    data-placeholder="ជ្រើសរើសឃុំ"
                                    data-disabled-placeholder="សូមជ្រើសស្រុកជាមុន"
                                    <?php echo e($selectedDistrict ? '' : 'disabled'); ?>>
                                    <option value="">
                                        <?php echo e($selectedDistrict ? 'ជ្រើសរើសឃុំ' : 'សូមជ្រើសស្រុកជាមុន'); ?>

                                    </option>
                                    <?php $__currentLoopData = $communes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $commune): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($commune->id); ?>"
                                            <?php echo e($selectedCommune == $commune->id ? 'selected' : ''); ?>>
                                            <?php echo e($commune->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </label>
                            <label class="field">
                                <span>ភូមិ</span>
                                <select name="village_id" data-role="village"
                                    data-endpoint="<?php echo e(url('/locations/communes/:id/villages')); ?>"
                                    data-placeholder="ជ្រើសរើសភូមិ"
                                    data-disabled-placeholder="សូមជ្រើសឃុំជាមុន"
                                    <?php echo e($selectedCommune ? '' : 'disabled'); ?>>
                                    <option value="">
                                        <?php echo e($selectedCommune ? 'ជ្រើសរើសភូមិ' : 'សូមជ្រើសឃុំជាមុន'); ?>

                                    </option>
                                    <?php $__currentLoopData = $villages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $village): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($village->id); ?>"
                                            <?php echo e(old('village_id', $userinfo->village_id ?? '') == $village->id ? 'selected' : ''); ?>>
                                            <?php echo e($village->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </label>

                        </div>
                    </div>

                    <div class="fieldset">
                        <div class="fieldset-title">
                            <h4>ព័ត៌មានការសិក្សា</h4>
                        </div>
                        <div class="field-grid">
                            <label class="field">
                                <span>កម្រិតវប្បធម៌</span>
                                <select name="education_id" data-role="education" data-placeholder="ជ្រើសរើសកម្រិតវប្បធម៌">
                                    <option value="">ជ្រើសរើស</option>
                                    <?php $__currentLoopData = $educations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $edu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($edu->id); ?>"
                                            <?php echo e(old('education_id', $userinfo->education_id ?? '') == $edu->id ? 'selected' : ''); ?>>
                                            <?php echo e($edu->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </label>
                            <label class="field">
                                <span>ឆ្នាំសិក្សា</span>
                                <select name="education_year_id" data-role="education-year"
                                    data-endpoint="<?php echo e(url('/education/:id/years')); ?>"
                                    data-placeholder="ជ្រើសរើសឆ្នាំសិក្សា"
                                    data-disabled-placeholder="សូមជ្រើសកម្រិតវប្បធម៌មានមុន"
                                    <?php echo e(old('education_id', $userinfo->education_id ?? '') ? '' : 'disabled'); ?>>
                                    <option value="">
                                        <?php echo e(old('education_id', $userinfo->education_id ?? '') ? 'ជ្រើសរើសឆ្នាំសិក្សា' : 'សូមជ្រើសកម្រិតវប្បធម៌មានមុន'); ?>

                                    </option>
                                    <?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($year->id); ?>"
                                            <?php echo e(old('education_year_id', $userinfo->education_year_id ?? '') == $year->id ? 'selected' : ''); ?>>
                                            <?php echo e($year->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </label>
                            <label class="field">
                                <span>កុដិ</span>
                                <select name="kudi_id">
                                    <option value="">ជ្រើសរើសកុដិ</option>
                                    <?php $__currentLoopData = $kudis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kudi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($kudi->id); ?>"
                                            <?php echo e(old('kudi_id', $userinfo->kudi_id ?? '') == $kudi->id ? 'selected' : ''); ?>>
                                            <?php echo e($kudi->kudi_number); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </label>
                        </div>
                    </div>

                    <div class="fieldset">
                        <div class="fieldset-title">
                            <h4>ព័ត៌មានមាតាបិតា</h4>
                            <p>បំពេញឈ្មោះ និងមុខរបរមាតាបិតាដោយដៃ</p>
                        </div>
                        <div class="field-grid">
                            <label class="field">
                                <span>ឈ្មោះឪពុក </span>
                                <input type="text" name="father_name" value="<?php echo e(old('father_name', $userinfo->father_name ?? '')); ?>"
                                    placeholder="ឧ. លោក សុវណ្ណ">
                            </label>
                            <label class="field">
                                <span>មុខរបរ ឪពុក</span>
                                <input type="text" name="father_job" value="<?php echo e(old('father_job', $userinfo->father_job ?? '')); ?>"
                                    placeholder="ឧ. កសិករ">
                            </label>
                            <label class="field">
                                <span>ឈ្មោះម្ដាយ (បំពេញដោយដៃ)</span>
                                <input type="text" name="mother_name" value="<?php echo e(old('mother_name', $userinfo->mother_name ?? '')); ?>"
                                    placeholder="ឧ. លោកស្រី ផាន">
                            </label>
                            <label class="field">
                                <span>មុខរបរ ម្ដាយ</span>
                                <input type="text" name="mother_job" value="<?php echo e(old('mother_job', $userinfo->mother_job ?? '')); ?>"
                                    placeholder="ឧ. ជាងដេរ">
                            </label>
                        </div>
                    </div>

                    <div class="fieldset">
                        <div class="fieldset-title">
                            <h4>អាសយដ្ឋានបច្ចុប្បន្ន</h4>
                            <p>ទីកន្លែងរស់នៅបច្ចុប្បន្ន និងវត្តដែលស្នាក់នៅ</p>
                        </div>
                        <div class="field-grid">
                            <label class="field">
                                <span>ឈ្មោះវត្ត (វត្តនាគវ័ន)</span>
                                <input type="text" name="temple_name" value="<?php echo e(old('temple_name', $userinfo->temple_name ?? '')); ?>"
                                    placeholder="ឧ. វត្តនាគវ័ន">
                            </label>
                            <label class="field">
                                <span>ខេត្ត/ក្រុង (បច្ចុប្បន្ន)</span>
                                <select name="current_province_id" data-role="current-province" data-placeholder="ជ្រើសរើសខេត្ត">
                                    <option value=""><?php echo e(__('ជ្រើសរើសខេត្ត')); ?></option>
                                    <?php $__currentLoopData = $provinces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $province): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($province->id); ?>"
                                            <?php echo e(old('current_province_id', $userinfo->current_province_id ?? '') == $province->id ? 'selected' : ''); ?>>
                                            <?php echo e($province->name ?? $province->name_kh ?? $province->name_en); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </label>
                            <label class="field">
                                <span>ស្រុក/ខណ្ឌ (បច្ចុប្បន្ន)</span>
                                <select name="current_district_id" data-role="current-district"
                                    data-endpoint="<?php echo e(url('/locations/provinces/:id/districts')); ?>"
                                    data-placeholder="ជ្រើសរើសស្រុក"
                                    data-disabled-placeholder="សូមជ្រើសខេត្តជាមុន"
                                    <?php echo e(old('current_province_id', $userinfo->current_province_id ?? '') ? '' : 'disabled'); ?>>
                                    <option value="">
                                        <?php echo e(old('current_province_id', $userinfo->current_province_id ?? '') ? 'ជ្រើសរើសស្រុក' : 'សូមជ្រើសខេត្តជាមុន'); ?>

                                    </option>
                                </select>
                            </label>
                            <label class="field">
                                <span>ឃុំ/សង្កាត់ (បច្ចុប្បន្ន)</span>
                                <select name="current_commune_id" data-role="current-commune"
                                    data-endpoint="<?php echo e(url('/locations/districts/:id/communes')); ?>"
                                    data-placeholder="ជ្រើសរើសឃុំ"
                                    data-disabled-placeholder="សូមជ្រើសស្រុកជាមុន"
                                    <?php echo e(old('current_district_id', $userinfo->current_district_id ?? '') ? '' : 'disabled'); ?>>
                                    <option value="">
                                        <?php echo e(old('current_district_id', $userinfo->current_district_id ?? '') ? 'ជ្រើសរើសឃុំ' : 'សូមជ្រើសស្រុកជាមុន'); ?>

                                    </option>
                                </select>
                            </label>
                            <label class="field">
                                <span>ភូមិ (បច្ចុប្បន្ន)</span>
                                <select name="current_village_id" data-role="current-village"
                                    data-endpoint="<?php echo e(url('/locations/communes/:id/villages')); ?>"
                                    data-placeholder="ជ្រើសរើសភូមិ"
                                    data-disabled-placeholder="សូមជ្រើសឃុំជាមុន"
                                    <?php echo e(old('current_commune_id', $userinfo->current_commune_id ?? '') ? '' : 'disabled'); ?>>
                                    <option value="">
                                        <?php echo e(old('current_commune_id', $userinfo->current_commune_id ?? '') ? 'ជ្រើសរើសភូមិ' : 'សូមជ្រើសឃុំជាមុន'); ?>

                                    </option>
                                </select>
                            </label>
                        </div>
                    </div>

                    <div class="fieldset">
                        <div class="fieldset-title">
                            <h4>ទំនាក់ទំនងបន្ថែម</h4>
                        </div>
                        <div class="field-grid">
                            <label class="field field-full">
                                <span>លេខទូរស័ព្ទ</span>
                                <input type="tel" name="phone_number"
                                    value="<?php echo e(old('phone_number', $userinfo->phone_number ?? '')); ?>"
                                    placeholder="លេខទូរស័ព្ទ">
                            </label>
                            <div class="field field-full file-field">
                                <span>រូបថតសិស្ស</span>
                                <?php if(isset($userinfo) && $userinfo->image): ?>
                                    <div style="margin-bottom: 0.75rem;">
                                        <img src="<?php echo e(asset('storage/' . $userinfo->image)); ?>" alt="<?php echo e($userinfo->name_kh ?? ''); ?>" style="width: 100px; height: 100px; object-fit: cover; border-radius: 12px; border: 2px solid #e5e7eb;">
                                    </div>
                                <?php endif; ?>
                                <input type="file" name="image" id="image-input" accept="image/*" <?php echo e(isset($userinfo) && $userinfo->image ? '' : 'required'); ?>>
                            </div>
                        </div>
                    </div>
                </article>

                <div class="form-footer">
                    <button class="btn btn-outline" type="reset">សម្អាតទិន្នន័យ</button>
                    <button class="btn btn-primary" type="submit"><?php echo e(isset($userinfo) && $userinfo->exists ? 'កែប្រែ' : 'រក្សាទុក'); ?></button>
                </div>
            </form>
        </section>
    </div>

<?php $__env->startPush('script'); ?>
    <?php echo $__env->make('admin.components.location-select-script', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.components.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\monkManagment\resources\views/User/form.blade.php ENDPATH**/ ?>