<?php $__env->startSection('content'); ?>
    <div class="page">
        <!-- Quick Navigation -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h3 class="mb-1"><?php echo e(isset($user) ? 'កែប្រែអ្នកប្រើប្រាស់' : 'បង្កើតអ្នកប្រើប្រាស់ថ្មី'); ?></h3>
                <p class="text-muted mb-0"><?php echo e(isset($user) ? 'កែប្រែព័ត៌មានអ្នកប្រើប្រាស់' : 'បញ្ចូលព័ត៌មានអ្នកប្រើប្រាស់ថ្មី'); ?></p>
            </div>
            <div>
                <a href="<?php echo e(route('dashboard.index')); ?>" class="btn btn-outline-primary">
                    <i class="iconoir-home me-1"></i>
                    Dashboard
                </a>
                <a href="<?php echo e(route('user.index')); ?>" class="btn btn-outline-secondary ms-2">
                    <i class="iconoir-arrow-left me-1"></i>
                    ត្រឡប់ទៅបញ្ជី
                </a>
            </div>
        </div>
        
        <section class="form-section" id="register">
            <form class="register-form" action="<?php echo e(isset($user) ? route('user.edit', $user->id) : route('user.create')); ?>"
                method="post" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <article class="student-card">
                    <div class="fieldset">
                        <div class="fieldset-title">
                            <h4>ព័ត៌មានផ្ទាល់ខ្លួន</h4>
                            <p>អត្តសញ្ញាណ និងព័ត៌មានផ្ទាល់ខ្លួនទាំងអស់</p>
                        </div>
                        <div class="field-grid">
                            <label class="field">
                                <span>ឈ្មោះ (អក្សរឡាតាំង)</span>
                                <input type="text" name="name" value="<?php echo e(old('name', $user->name ?? '')); ?>">
                            </label>
                            
                            <label class="field">
                                <span>តួនាទី</span>
                                <select name="role" class="form-control" required>
                                    <option value="">-- ជ្រើសរើសតួនាទី --</option>
                                    <option value="admin" <?php echo e((isset($user) && $user->role == 'admin') || old('role') == 'admin' ? 'selected' : ''); ?>>
                                        admin
                                    </option>
                                    <option value="super_admin" <?php echo e((isset($user) && $user->role == 'super_admin') || old('role') == 'super_admin' ? 'selected' : ''); ?>>
                                        super_admin
                                    </option>
                                </select>
                            </label>
                            <label class="field">
                                <span>ពាក្យសម្ងាត់ <?php echo e(isset($user) ? '(ទុកទទេបើមិនចង់ផ្លាស់ប្តូរ)' : ''); ?></span>
                                <input type="password" name="password" placeholder="<?php echo e(isset($user) ? '••••••••' : 'បញ្ចូលពាក្យសម្ងាត់'); ?>">
                            </label>
                           
                
                            <?php if(!isset($user) || $user->role != 'super_admin'): ?>
                            <label for="" class="field">
                                <span>ជ្រើសរើសកុដិ</span>
                                <select name="kudi_id" class="form-control" <?php echo e((!isset($user) || old('role', $user->role ?? '') != 'super_admin') ? 'required' : ''); ?>>
                                    <option value="">-- ជ្រើសរើសកុដិ --</option>
                                    <?php $__currentLoopData = $kudi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($item->id); ?>"
                                            <?php echo e((isset($user) && $user->kudi_id == $item->id) || old('kudi_id') == $item->id ? 'selected' : ''); ?>>
                                            <?php echo e($item->kudi_number); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                            </label>
                            <?php else: ?>
                            <input type="hidden" name="kudi_id" value="">
                            <?php endif; ?>
                            <?php if(isset($user) && $user->image): ?>
                                <div class="field">
                                    <span>Current Image:</span>
                                    <img src="<?php echo e(Storage::url($user->image)); ?>" alt=""
                                        style="width: 100px; height: 100px; object-fit: cover;">
                                </div>
                            <?php endif; ?>
                            <label class="field">
                                <span>រូបភាព</span>
                                <input type="file" name="image">
                            </label>

                        </div>
                    </div>
                    <div>
                        <?php if(session('success')): ?>
                            <p class="text-sucess"><?php echo e(session('success')); ?></p>
                        <?php endif; ?>
                        <?php if($errors->any()): ?>
           
                        
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p class="text-danger">  <?php echo e($error); ?></p>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        
                             <?php endif; ?>
                    </div>
                    <div class="form-footer">
                        <button class="btn btn-outline" type="reset">សម្អាតទិន្នន័យ</button>
                        <button class="btn btn-primary" type="submit"><?php echo e(isset($user) ? 'កែប្រែ' : 'រក្សាទុក'); ?></button>
                    </div>
                </article>
            </form>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.components.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\monkManagment\resources\views/admin/user/form.blade.php ENDPATH**/ ?>