<?php
    $name = $name ?? 'date';
    $value = $value ?? null;
    $required = $required ?? false;
    $placeholder = $placeholder ?? 'ជ្រើសរើសថ្ងៃខែឆ្នាំ';
    $disabled = $disabled ?? false;
    $class = $class ?? 'form-control';
?>

<!-- Simple Khmer Date Picker -->
<select name="<?php echo e($name); ?>" class="<?php echo e($class); ?>" <?php echo e($required ? 'required' : ''); ?> <?php echo e($disabled ? 'disabled' : ''); ?>>
    <option value=""><?php echo e($placeholder); ?></option>
    <?php
    if ($value) {
        try {
            $date = new DateTime($value);
            $year = $date->format('Y');
            $month = $date->format('n'); // 1-12
            $day = $date->format('j'); // 1-31
        } catch (Exception $e) {
            $year = date('Y');
            $month = date('n');
            $day = date('j');
        }
    } else {
        $year = date('Y');
        $month = date('n');
        $day = date('j');
    }
    
    $khmerMonths = [
        1 => 'មករា', 2 => 'កុម្ភៈ', 3 => 'មីនា', 4 => 'មេសា',
        5 => 'ឧសភា', 6 => 'មិថុនា', 7 => 'កក្កដា', 8 => 'សីហា',
        9 => 'កញ្ញា', 10 => 'តុលា', 11 => 'វិច្ឆិកា', 12 => 'ធ្នូ'
    ];
    
    // Generate options for the last 100 years
    for ($y = $year; $y >= $year - 100; $y--) {
        for ($m = 12; $m >= 1; $m--) {
            for ($d = 31; $d >= 1; $d--) {
                // Check if this day exists in this month/year
                if (checkdate($m, $d, $y)) {
                    $dateString = sprintf('%04d-%02d-%02d', $y, $m, $d);
                    $khmerDate = sprintf('%d %s %d', $d, $khmerMonths[$m], $y);
                    $selected = ($value == $dateString) ? 'selected' : '';
                    echo "<option value=\"{$dateString}\" {$selected}>{$khmerDate}</option>";
                }
            }
        }
    }
    ?>
</select>

<style>
.khmer-date-simple {
    font-family: 'Kantumruy Pro', system-ui, sans-serif;
    padding: 10px;
    border: 2px solid #e9ecef;
    border-radius: 8px;
    font-size: 14px;
    background: white;
    cursor: pointer;
}

.khmer-date-simple:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
}
</style>
<?php /**PATH D:\monkManagment\resources\views/admin/components/khmer-date-picker-simple.blade.php ENDPATH**/ ?>