<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('assets/js/kudi-filter.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('css'); ?>
<style>
/* Dashboard Responsive Styles */
@media (max-width: 768px) {
    .container-fluid {
        padding: 0 15px;
    }
    
    /* Cards responsive */
    .row.mt-5 {
        margin-top: 1rem !important;
    }
    
    .col-xl-3.col-md-6.mb-4 {
        margin-bottom: 1rem;
        padding-left: 0.5rem;
        padding-right: 0.5rem;
    }
    
    .card {
        margin-bottom: 1rem;
    }
    
    .card-body {
        padding: 1rem !important;
    }
    
    .row.no-gutters.align-items-center {
        flex-direction: column;
        text-align: center;
    }
    
    .col.mr-2 {
        margin-right: 0;
        margin-bottom: 0.5rem;
    }
    
    .col-auto {
        margin-left: 0;
    }
    
    .text-xs.font-weight-bold {
        font-size: 0.75rem !important;
    }
    
    .h5.mb-0 {
        font-size: 1.25rem !important;
    }
    
    .fa-2x {
        font-size: 1.5rem !important;
    }
    
    /* Table responsive */
    .table-responsive {
        font-size: 0.875rem;
    }
    
    .table th,
    .table td {
        padding: 0.5rem;
        vertical-align: middle;
    }
    
    .badge.badge-primary.badge-pill {
        font-size: 0.875rem !important;
        padding: 0.25rem 0.75rem !important;
    }
    
    /* Header responsive */
    .d-sm-flex.align-items-center.justify-content-between.mb-4 {
        flex-direction: column;
        align-items: flex-start !important;
        gap: 1rem;
    }
    
    .h3.mb-0 {
        font-size: 1.5rem;
        margin-bottom: 0.5rem !important;
    }
    
    .btn-sm {
        font-size: 0.875rem;
        padding: 0.5rem 1rem;
    }
}

@media (max-width: 576px) {
    .container-fluid {
        padding: 0 10px;
    }
    
    .col-xl-3.col-md-6.mb-4 {
        padding-left: 0.25rem;
        padding-right: 0.25rem;
    }
    
    .card-body {
        padding: 0.75rem !important;
    }
    
    .text-xs.font-weight-bold {
        font-size: 0.7rem !important;
    }
    
    .h5.mb-0 {
        font-size: 1.1rem !important;
    }
    
    .table-responsive {
        font-size: 0.8rem;
    }
    
    .table th,
    .table td {
        padding: 0.25rem;
    }
    
    .badge.badge-primary.badge-pill {
        font-size: 0.75rem !important;
        padding: 0.2rem 0.5rem !important;
    }
}

/* Ensure proper spacing on all screens */
.card.border-left-primary,
.card.border-left-success,
.card.border-left-info,
.card.border-left-warning {
    border-left-width: 4px !important;
}

/* Fix card height consistency */
.card.h-100 {
    height: auto !important;
    min-height: 120px;
}

@media (max-width: 768px) {
    .card.h-100 {
        min-height: 100px;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <!-- Page Heading -->
        <div class="d-sm-flex align-items-center justify-content-between mb-4">
            <h1 class="h3 mb-0 text-gray-800">Dashboard</h1>
            <?php if(session()->has('user_id')): ?>
                <?php $user = App\Models\UserModel::find(session('user_id')); ?>
                <?php if($user && $user->hasRole('super_admin')): ?>
                    <a href="<?php echo e(route('admin.export.members')); ?>"
                        class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm">
                        <i class="fas fa-download fa-sm text-white-50"></i> ទាញយកទិន្ន័យ
                    </a>
                <?php endif; ?>
            <?php endif; ?>
        </div>

        <!-- Content Row -->
        <div class="row mt-5">
            <!-- Total Members Card -->
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-primary shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                    ចំនួនសមាជិកសរុប</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($totalMembers); ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-users fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Monks Card -->
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-success shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                    ចំនួន ភិក្ខុ</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($monks); ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-user-tie fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Novices Card -->
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-info shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                    ចំនួន សាមណេរ</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($novices); ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-user-graduate fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Kudi Card -->
            <div class="col-xl-3 col-md-6 mb-4">
                <div class="card border-left-warning shadow h-100 py-2">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                    ចំនួន កុដិ</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($kudis); ?></div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-home fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Members by Kudi -->
        <div class="card shadow mb-4">
            
            <div class="card-body">
                <h5 class="mb-3">តារាង ចំនួនសមាជិកតាមកុដិ</h5>
                
                <!-- Filter Section -->
                <?php echo $__env->make('admin.components.kudi-filter', [
                    'title' => 'តារាង ចំនួនសមាជិកតាមកុដិ',
                    'subtitle' => 'ទិន្ន័យសមាជិកតាមកុដិទាំងអស់',
                    'filterLabel' => '',
                    'filterAction' => route('dashboard.index'),
                    'kudis' => $allKudis ?? collect(),
                    'selectedKudiId' => request('kudi_filter')
                ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                <?php if($membersByKudi->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover" id="datatable_1">
                            <thead class="bg-light">
                                <tr>
                                    <th style="width: 10%;">ល.រ</th>
                                    <th style="width: 40%;">ចំនួន តាមកុដិ</th>
                                    <th style="width: 30%;">ចំនួនសមាជិក</th>
                                   
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $membersByKudi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $kudi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="text-center"><?php echo e($index + 1); ?></td>
                                        <td><strong>កុដិ <?php echo e($kudi['kudi_number']); ?></strong></td>
                                        <td class="text-center">
                                            <span class="badge badge-primary badge-pill" style="font-size: 1rem; padding: 0.5rem 1rem; color:black">
                                                <?php echo e($kudi['total']); ?>

                                            </span>
                                        </td>
                                        
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="alert alert-info text-center">
                        <i class="fas fa-info-circle"></i> មិនមានទិន្នន័យសមាជិកនៅឡើយទេ។ (No member data available yet.)
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.components.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\monkManagment\resources\views/admin/dashboard/index.blade.php ENDPATH**/ ?>