<?php
    $title = $title ?? 'សមាជិកកុដិ';
    $subtitle = $subtitle ?? 'ទិន្ន័យព្រះសង្ឃតាមកុដិទាំងអស់';
    $filterLabel = $filterLabel ?? null;
    $createLabel = $createLabel ?? 'បង្កើតថ្មី';
    $filterAction = $filterAction ?? '#';
    $kudiOptions = ($kudis ?? $kudiOptions ?? collect()) instanceof \Illuminate\Support\Collection ? ($kudis ?? $kudiOptions ?? collect()) : collect($kudis ?? $kudiOptions ?? []);
    $selectedKudiId = $selectedKudiId ?? null;
    $stats = $stats ?? [];
    $downloadRoute = $downloadRoute ?? null;
?>

<?php $__env->startPush('css'); ?>
    <?php if (! $__env->hasRenderedOnce('a7b3cb9b-7f46-4e7d-b08c-f228532f92ec')): $__env->markAsRenderedOnce('a7b3cb9b-7f46-4e7d-b08c-f228532f92ec'); ?>
        <style>
            .kudi-filter-card {
                background: #ffffff;
                border-radius: 16px;
                padding: 2rem;
                box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
                border: 1px solid rgba(0, 0, 0, 0.06);
            }

            .kudi-filter-card::before,
            .kudi-filter-card::after {
                content: '';
                position: absolute;
                border-radius: 50%;
                filter: blur(90px);
                opacity: 0.5;
                pointer-events: none;
            }

            .kudi-filter-card::before {
                width: 220px;
                height: 220px;
                background: rgba(123, 155, 255, 0.6);
                top: -70px;
                right: -40px;
            }

            .kudi-filter-card::after {
                width: 100px;
                height: 100px;
                background: rgba(255, 255, 255, 0.7);
                bottom: -70px;
                left: -40px;
            }

            .kudi-filter-shell {
                position: relative;
                z-index: 1;
            }

            .kudi-filter-title {
                display: flex;
                justify-content: space-between;
                align-items: center;
                margin-bottom: 2rem;
                flex-wrap: wrap;
                gap: 1rem;
            }

            .kudi-filter-title h3 {
                font-weight: 700;
                font-size: 1.1rem;
                margin: 0;
                color: #1f2937;
                flex: 1;
            }

            .kudi-filter-title p {
                color: #6b7280;
                font-size: 0.8rem;
                margin: 0;
                line-height: 1.5;
                flex: 0 0 auto;
            }

            .kudi-filter-stats {
                display: flex;
                flex-wrap: nowrap;
                gap: 1rem;
                align-items: center;
            }

            .kudi-filter-stat {
                background: #f9fafb;
                border-radius: 12px;
                padding: 1rem 1.5rem;
                min-width: 120px;
                text-align: center;
                border: 1px solid #e5e7eb;
                flex: 1;
                transition: all 0.2s ease;
            }

            .kudi-filter-stat:hover {
                background: #f3f4f6;
                border-color: #d1d5db;
            }

            .kudi-filter-stat span {
                display: block;
                font-size: 0.72rem;
                letter-spacing: 0.08em;
                text-transform: uppercase;
                color: #6a6f99;
                margin-bottom: 0.15rem;
            }

            .kudi-filter-stat strong {
                font-size: 1.1rem;
                color: #25284d;
                font-weight: 700;
            }

            .kudi-filter-actions {
                background: rgba(255, 255, 255, 0.94);
                border-radius: 18px;
                padding: 1rem 1.1rem;
                box-shadow: 0 20px 40px rgba(64, 76, 140, 0.15);
                min-width: 260px;
            }

            .kudi-filter-actions label {
                font-size: 0.78rem;
                font-weight: 600;
                letter-spacing: 0.12em;
                text-transform: uppercase;
                color: #7a84b6;
                margin-bottom: 0.5rem;
            }

            .kudi-filter-select {
                border-radius: 12px;
                border: 1px solid rgba(146, 150, 199, 0.35);
                padding: 0.7rem 0.9rem;
                font-weight: 600;
                font-size: 0.9rem;
                color: #1f2566;
                box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.9);
                height: 48px;
            }

            .kudi-filter-reset {
                font-size: 0.82rem;
                color: #5a6cff;
                font-weight: 600;
                text-decoration: none;
                transition: opacity 0.2s ease;
            }

            .kudi-filter-reset:hover {
                opacity: 0.7;
            }

            .kudi-filter-create {
                border-radius: 12px;
                padding: 0.7rem 1.2rem;
                font-weight: 600;
                font-size: 0.9rem;
                border: 2px solid transparent;
                text-transform: none;
                letter-spacing: 0.02em;
                height: 48px;
                display: flex;
                align-items: center;
                white-space: nowrap;
                transition: all 0.2s ease;
                cursor: pointer;
            }

            .kudi-filter-create:hover {
                border-color: rgba(255, 255, 255, 0.3);
                transform: translateY(-1px);
                box-shadow: 0 4px 12px rgba(33, 56, 146, 0.2);
            }

            .kudi-filter-create.btn-primary {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                color: white;
                border: none;
            }

            .kudi-filter-create.btn-primary:hover {
                background: linear-gradient(135deg, #5a6fd8 0%, #6a4190 100%);
            }

            @media (max-width: 768px) {
                .kudi-filter-card {
                    padding: 1.1rem;
                }

                .kudi-filter-actions {
                    width: 100%;
                }
            }
        </style>
    <?php endif; ?>
<?php $__env->stopPush(); ?>

<div class="mb-4">
    <!-- Stats Row -->
    

    <!-- Filter and Create Actions -->
    <div class="kudi-filter-actions">
        <form method="GET" action="<?php echo e($filterAction); ?>" id="kudiFilterForm">
            <div class="d-flex gap-2 align-items-center">
                <div class="flex-grow-1 mb-0">
                    <?php if(!empty($filterLabel)): ?>
                        <label class="form-label small mb-1"><?php echo e($filterLabel); ?></label>
                    <?php endif; ?>
                    <select class="kudi-filter-select" name="kudi_id" id="kudiFilterSelect">
                        <option value=""><?php echo e($allLabel ?? 'កុដិទាំងអស់'); ?></option>
                       
                        <?php $__currentLoopData = $kudiOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kudi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($kudi->id); ?>" <?php echo e((string) $selectedKudiId === (string) $kudi->id ? 'selected' : ''); ?>>
                                <?php echo e($kudi->kudi_number); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                
                <?php if(!empty($createRoute)): ?>
                    <a href="<?php echo e($createRoute); ?>" class="kudi-filter-create flex-shrink-0">
                        <?php echo e($createLabel); ?>

                    </a>
                <?php endif; ?>
                <?php if(!empty($downloadRoute)): ?>
                    <a href="<?php echo e($downloadRoute); ?>" class="kudi-filter-create flex-shrink-0 btn-primary">
                        <i class="fas fa-download me-1"></i> ទាញយកទិន្ន៍យ
                    </a>
                <?php endif; ?>
            </div>
        </form>
    </div>
</div>
<?php /**PATH D:\monkManagment\resources\views/admin/components/kudi-filter.blade.php ENDPATH**/ ?>