<?php
    $name = $name ?? 'date';
    $value = $value ?? null;
    $required = $required ?? false;
    $placeholder = $placeholder ?? 'ជ្រើសរើសថ្ងៃខែឆ្នាំ';
    $disabled = $disabled ?? false;
    $class = $class ?? 'form-control';
?>

<!-- Khmer Date Picker Component -->
<div class="khmer-date-input-group">
    <input 
        type="text" 
        name="<?php echo e($name); ?>" 
        value="<?php echo e($value); ?>"
        placeholder="<?php echo e($placeholder); ?>"
        class="<?php echo e($class); ?> khmer-date-input"
        <?php echo e($required ? 'required' : ''); ?>

        <?php echo e($disabled ? 'disabled' : ''); ?>

        readonly
        style="cursor: pointer;"
    >
    <button type="button" class="khmer-date-btn" <?php echo e($disabled ? 'disabled' : ''); ?> style="cursor: pointer;">
        📅
    </button>
</div>

<!-- Khmer Date Picker Modal -->
<div class="khmer-date-modal" id="khmer-date-modal-<?php echo e($name); ?>" style="display: none;">
    <div class="khmer-date-content">
        <div class="khmer-date-header">
            <h5>ជ្រើសរើសថ្ងៃខែឆ្នាំ</h5>
            <button type="button" class="khmer-date-close">&times;</button>
        </div>
        <div class="khmer-date-body">
            <div class="khmer-date-selectors">
                <div class="khmer-date-selector">
                    <label>ថ្ងៃ</label>
                    <select class="khmer-day" data-name="<?php echo e($name); ?>">
                        <?php for($i = 1; $i <= 31; $i++): ?>
                            <option value="<?php echo e(str_pad($i, 2, '0', STR_PAD_LEFT)); ?>"><?php echo e($i); ?></option>
                        <?php endfor; ?>
                    </select>
                </div>
                <div class="khmer-date-selector">
                    <label>ខែ</label>
                    <select class="khmer-month" data-name="<?php echo e($name); ?>">
                        <option value="01">មករា</option>
                        <option value="02">កុម្ភៈ</option>
                        <option value="03">មីនា</option>
                        <option value="04">មេសា</option>
                        <option value="05">ឧសភា</option>
                        <option value="06">មិថុនា</option>
                        <option value="07">កក្កដា</option>
                        <option value="08">សីហា</option>
                        <option value="09">កញ្ញា</option>
                        <option value="10">តុលា</option>
                        <option value="11">វិច្ឆិកា</option>
                        <option value="12">ធ្នូ</option>
                    </select>
                </div>
                <div class="khmer-date-selector">
                    <label>ឆ្នាំ</label>
                    <select class="khmer-year" data-name="<?php echo e($name); ?>">
                        <?php
                        $currentYear = date('Y');
                        $startYear = $currentYear - 100;
                        $endYear = $currentYear + 10;
                        ?>
                        <?php for($i = $endYear; $i >= $startYear; $i--): ?>
                            <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                        <?php endfor; ?>
                    </select>
                </div>
            </div>
        </div>
        <div class="khmer-date-footer">
            <button type="button" class="btn btn-secondary khmer-date-cancel">បោះបង់</button>
            <button type="button" class="btn btn-primary khmer-date-confirm" data-name="<?php echo e($name); ?>">យល់ព្រម</button>
        </div>
    </div>
</div>

<style>
/* Khmer Date Picker Styles */
.khmer-date-input-group {
    display: flex;
    align-items: stretch;
    gap: 0;
}

.khmer-date-input {
    border-top-right-radius: 0 !important;
    border-bottom-right-radius: 0 !important;
    cursor: pointer;
}

.khmer-date-btn {
    border-top-left-radius: 0 !important;
    border-bottom-left-radius: 0 !important;
    border: 1px solid #ced4da;
    border-left: none;
    background: #f8f9fa;
    padding: 0 12px;
    cursor: pointer;
    transition: all 0.2s ease;
    font-size: 16px;
}

.khmer-date-btn:hover:not(:disabled) {
    background: #e9ecef;
    border-color: #adb5bd;
}

.khmer-date-btn:disabled {
    opacity: 0.6;
    cursor: not-allowed;
}

/* Modal Styles */
.khmer-date-modal {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.7);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 99999;
    font-family: 'Kantumruy Pro', system-ui, sans-serif;
}

.khmer-date-content {
    background: white;
    border-radius: 12px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
    max-width: 450px;
    width: 90%;
    max-height: 90vh;
    overflow: hidden;
}

.khmer-date-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 20px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.khmer-date-header h5 {
    margin: 0;
    font-size: 18px;
    font-weight: 600;
}

.khmer-date-close {
    background: none;
    border: none;
    color: white;
    font-size: 24px;
    cursor: pointer;
    padding: 0;
    width: 30px;
    height: 30px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 50%;
    transition: background 0.2s ease;
}

.khmer-date-close:hover {
    background: rgba(255, 255, 255, 0.2);
}

.khmer-date-body {
    padding: 30px 20px;
}

.khmer-date-selectors {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 15px;
    flex-wrap: wrap;
}

.khmer-date-selector {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 8px;
    min-width: 80px;
}

.khmer-date-selector label {
    font-size: 14px;
    font-weight: 500;
    color: #495057;
}

.khmer-date-selector select {
    width: 100%;
    padding: 10px;
    border: 2px solid #e9ecef;
    border-radius: 8px;
    font-size: 16px;
    text-align: center;
    font-family: 'Kantumruy Pro', system-ui, sans-serif;
    background: white;
    cursor: pointer;
    transition: border-color 0.2s ease;
    -webkit-appearance: none;
    -moz-appearance: none;
    appearance: none;
    position: relative;
}

.khmer-date-selector select::-ms-expand {
    display: none;
}

.khmer-date-selector select::-webkit-scrollbar {
    width: 8px;
}

.khmer-date-selector select::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 4px;
}

.khmer-date-selector select::-webkit-scrollbar-thumb {
    background: #888;
    border-radius: 4px;
}

.khmer-date-selector select:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    z-index: 1;
    position: relative;
}

.khmer-date-footer {
    padding: 20px;
    border-top: 1px solid #e9ecef;
    display: flex;
    justify-content: flex-end;
    gap: 10px;
    background: #f8f9fa;
}

.khmer-date-footer .btn {
    padding: 8px 20px;
    border-radius: 6px;
    font-size: 14px;
    font-weight: 500;
    font-family: 'Kantumruy Pro', system-ui, sans-serif;
    border: none;
    cursor: pointer;
    transition: all 0.2s ease;
}

.khmer-date-footer .btn-secondary {
    background: #6c757d;
    color: white;
}

.khmer-date-footer .btn-secondary:hover {
    background: #5a6268;
}

.khmer-date-footer .btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.khmer-date-footer .btn-primary:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.3);
}
</style>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    console.log('Khmer Date Picker: Initializing...');
    
    const datePickers = document.querySelectorAll('.khmer-date-input-group');
    console.log('Khmer Date Picker: Found ' + datePickers.length + ' date pickers');
    
    datePickers.forEach(function(pickerGroup, index) {
        console.log('Khmer Date Picker: Processing picker #' + index);
        
        const input = pickerGroup.querySelector('.khmer-date-input');
        const button = pickerGroup.querySelector('.khmer-date-btn');
        const name = input.name;
        const modal = document.getElementById('khmer-date-modal-' + name);
        
        console.log('Khmer Date Picker: Input name=' + name + ', Modal found=' + !!modal);
        
        if (!modal) {
            console.error('Khmer Date Picker: Modal not found for name=' + name);
            return;
        }
        
        const daySelect = modal.querySelector('.khmer-day');
        const monthSelect = modal.querySelector('.khmer-month');
        const yearSelect = modal.querySelector('.khmer-year');
        const confirmBtn = modal.querySelector('.khmer-date-confirm');
        const cancelBtn = modal.querySelector('.khmer-date-cancel');
        const closeBtn = modal.querySelector('.khmer-date-close');
        
        console.log('Khmer Date Picker: All elements found');
        
        function openModal() {
            console.log('Khmer Date Picker: Opening modal for ' + name);
            modal.style.display = 'flex';
            modal.style.zIndex = '99999';
            
            const currentValue = input.value;
            console.log('Khmer Date Picker: Current value=' + currentValue);
            
            if (currentValue && currentValue.match(/^\d{4}-\d{2}-\d{2}$/)) {
                const [year, month, day] = currentValue.split('-');
                yearSelect.value = year;
                monthSelect.value = month;
                daySelect.value = day;
            } else if (currentValue && currentValue.match(/^\d{2}\/\d{2}\/\d{4}$/)) {
                const [month, day, year] = currentValue.split('/');
                yearSelect.value = year;
                monthSelect.value = month;
                daySelect.value = day;
            } else {
                const now = new Date();
                yearSelect.value = now.getFullYear();
                monthSelect.value = String(now.getMonth() + 1).padStart(2, '0');
                daySelect.value = String(now.getDate()).padStart(2, '0');
            }
            
            updateDays();
        }
        
        function closeModal() {
            console.log('Khmer Date Picker: Closing modal');
            modal.style.display = 'none';
        }
        
        function updateDays() {
            const year = parseInt(yearSelect.value);
            const month = parseInt(monthSelect.value);
            const daysInMonth = new Date(year, month, 0).getDate();
            
            const currentDay = parseInt(daySelect.value);
            
            daySelect.innerHTML = '';
            for (let i = 1; i <= daysInMonth; i++) {
                const option = document.createElement('option');
                option.value = String(i).padStart(2, '0');
                option.textContent = i;
                if (i === currentDay && i <= daysInMonth) {
                    option.selected = true;
                }
                daySelect.appendChild(option);
            }
        }
        
        function setDate() {
            const day = daySelect.value;
            const month = monthSelect.value;
            const year = yearSelect.value;
            const dateString = year + '-' + month + '-' + day;
            console.log('Khmer Date Picker: Setting date=' + dateString);
            input.value = dateString;
            
            const event = new Event('change', { bubbles: true });
            input.dispatchEvent(event);
            
            closeModal();
        }
        
        button.addEventListener('click', function(e) {
            console.log('Khmer Date Picker: Button clicked');
            e.preventDefault();
            e.stopPropagation();
            openModal();
        });
        
        input.addEventListener('click', function(e) {
            console.log('Khmer Date Picker: Input clicked');
            e.preventDefault();
            e.stopPropagation();
            openModal();
        });
        
        confirmBtn.addEventListener('click', function(e) {
            console.log('Khmer Date Picker: Confirm clicked');
            e.preventDefault();
            e.stopPropagation();
            setDate();
        });
        
        cancelBtn.addEventListener('click', function(e) {
            console.log('Khmer Date Picker: Cancel clicked');
            e.preventDefault();
            e.stopPropagation();
            closeModal();
        });
        
        closeBtn.addEventListener('click', function(e) {
            console.log('Khmer Date Picker: Close clicked');
            e.preventDefault();
            e.stopPropagation();
            closeModal();
        });
        
        monthSelect.addEventListener('change', updateDays);
        yearSelect.addEventListener('change', updateDays);
        
        modal.addEventListener('click', function(e) {
            // Only close if clicking the modal background, not the content
            if (e.target === modal) {
                closeModal();
            }
        });
        
        // Prevent modal from closing when clicking inside the content
        const modalContent = modal.querySelector('.khmer-date-content');
        if (modalContent) {
            modalContent.addEventListener('click', function(e) {
                e.stopPropagation();
            });
        }
        
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape' && modal.style.display === 'flex') {
                closeModal();
            }
        });
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH D:\monkManagment\resources\views/admin/components/khmer-date-picker.blade.php ENDPATH**/ ?>