<div class="user-detail-container ">
    <!-- User Profile Header -->
    <div class="user-profile-header">
        <div class="user-profile-image-container">
            <?php if($info->image): ?>
                <img src="<?php echo e(asset('storage/' . $info->image)); ?>" 
                     alt="<?php echo e($info->name_kh); ?>" 
                     class="user-profile-image"
                     onclick="openUserImageModal(this, '<?php echo e($info->name_kh); ?>')"
                     style="cursor: pointer;">
            <?php else: ?>
                <div class="user-profile-image d-flex align-items-center justify-content-center bg-light">
                    <i class="fas fa-user fa-3x text-muted"></i>
                </div>
            <?php endif; ?>
        </div>
        
        <div class="user-profile-info flex-grow-1">
            <h3><?php echo e($info->name_kh); ?></h3>
            <div class="user-meta">
                <div class="user-meta-item">
                    <i class="fas fa-id-card"></i>
                    <span><?php echo e($info->id_number); ?></span>
                </div>
                <?php if($info->phone_number): ?>
                <div class="user-meta-item">
                    <i class="fas fa-phone"></i>
                    <span><?php echo e($info->phone_number); ?></span>
                </div>
                <?php endif; ?>
                <?php if($info->monkType): ?>
                <div class="user-meta-item">
                    <i class="fas fa-pray"></i>
                    <span><?php echo e($info->monkType->name); ?></span>
                </div>
                <?php endif; ?>
                <?php if($info->kudi): ?>
                <div class="user-meta-item">
                    <i class="fas fa-home"></i>
                    <span> <?php echo e($info->kudi->kudi_number); ?></span>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Personal Information Section -->
    <div class="info-section">
        <h6 class="info-section-title">
            <i class="fas fa-user me-2"></i>
            ព័ត៌មានផ្ទាល់ខ្លួន
        </h6>
        <div class="info-grid">
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-user"></i>
                    ឈ្មោះ (ខ្មែរ):
                </div>
                <div class="info-value"><?php echo e($info->name_kh); ?></div>
            </div>
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-user"></i>
                    ឈ្មោះ (ឡាតាំង):
                </div>
                <div class="info-value"><?php echo e($info->name_en); ?></div>
            </div>
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-id-card"></i>
                    អត្តលេខ:
                </div>
                <div class="info-value"><?php echo e($info->id_number); ?></div>
            </div>
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-phone"></i>
                    លេខទូរស័ព្ទ:
                </div>
                <div class="info-value"><?php echo e($info->phone_number ?? '—'); ?></div>
            </div>
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-birthday-cake"></i>
                    ថ្ងៃកំណើត:
                </div>
                <div class="info-value">
                    <?php if($info->dob): ?>
                        <?php echo e(\Carbon\Carbon::parse($info->dob)->format('d/m/Y')); ?>

                    <?php else: ?>
                        —
                    <?php endif; ?>
                </div>
            </div>
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-pray"></i>
                    ភិក្ខុ/សាមណេរ:
                </div>
                <div class="info-value"><?php echo e(optional($info->monkType)->name ?? '—'); ?></div>
            </div>
        </div>
    </div>

    <!-- Education Section -->
    <div class="info-section">
        <h6 class="info-section-title">
            <i class="fas fa-graduation-cap me-2"></i>
            ព័ត៌មានការសិក្សា
        </h6>
        <div class="info-grid">
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-graduation-cap"></i>
                    កម្រិតវប្បធម៌:
                </div>
                <div class="info-value"><?php echo e(optional($info->education)->name ?? '—'); ?></div>
            </div>
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-calendar-alt"></i>
                    ឆ្នាំសិក្សា:
                </div>
                <div class="info-value"><?php echo e(optional($info->educationYear)->name ?? '—'); ?></div>
            </div>
        </div>
    </div>

    <!-- Kudi Information -->
    <div class="info-section">
        <h6 class="info-section-title">
            <i class="fas fa-home me-2"></i>
            ព័ត៌មានកុដិ
        </h6>
        <div class="info-grid">
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-home"></i>
                    កុដិលេខ:
                </div>
                <div class="info-value"><?php echo e(optional($info->kudi)->kudi_number ?? '—'); ?></div>
            </div>
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-vihara"></i>
                    វត្តឈ្មោះ:
                </div>
                <div class="info-value"><?php echo e($info->temple_name ?? '—'); ?></div>
            </div>
        </div>
    </div>

    <!-- Family Information -->
    <div class="info-section">
        <h6 class="info-section-title">
            <i class="fas fa-users me-2"></i>
            ព័ត៌មានគ្រួសារ
        </h6>
        <div class="info-grid">
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-user-tie"></i>
                    ឈ្មោះឪពុក:
                </div>
                <div class="info-value">
                    <?php if($info->father_id && $info->father): ?>
                        <?php echo e($info->father->name); ?>

                    <?php elseif($info->father_name): ?>
                        <?php echo e($info->father_name); ?>

                    <?php else: ?>
                        —
                    <?php endif; ?>
                </div>
            </div>
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-briefcase"></i>
                    មុខរបរឪពុក:
                </div>
                <div class="info-value">
                    <?php if($info->father_id && $info->father): ?>
                        <?php echo e($info->father->job ?? '—'); ?>

                    <?php else: ?>
                        <?php echo e($info->father_job ?? '—'); ?>

                    <?php endif; ?>
                </div>
            </div>
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-user"></i>
                    ឈ្មោះម្ដាយ:
                </div>
                <div class="info-value">
                    <?php if($info->mother_id && $info->mother): ?>
                        <?php echo e($info->mother->name); ?>

                    <?php elseif($info->mother_name): ?>
                        <?php echo e($info->mother_name); ?>

                    <?php else: ?>
                        —
                    <?php endif; ?>
                </div>
            </div>
            <div class="info-item">
                <div class="info-label">
                    <i class="fas fa-briefcase"></i>
                    មុខរបរម្ដាយ:
                </div>
                <div class="info-value">
                    <?php if($info->mother_id && $info->mother): ?>
                        <?php echo e($info->mother->job ?? '—'); ?>

                    <?php else: ?>
                        <?php echo e($info->mother_job ?? '—'); ?>

                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Address Information -->
    <div class="info-section">
        <h6 class="info-section-title">
            <i class="fas fa-map-marker-alt me-2"></i>
            ព័ត៌មានអាសយដ្ឋាន
        </h6>
        
        <!-- Original Address -->
        <div class="address-card">
            <h6>
                <i class="fas fa-home me-2"></i>
                អាសយដ្ឋានកំណើត
            </h6>
            <div class="address-text">
                <?php if($info->village || $info->commune || $info->district || $info->province): ?>
                    <?php echo e(optional($info->village)->name ?? ''); ?>

                    <?php if($info->village && $info->commune): ?>, <?php endif; ?>
                    <?php echo e(optional($info->commune)->name ?? ''); ?>

                    <?php if($info->commune && $info->district): ?>, <?php endif; ?>
                    <?php echo e(optional($info->district)->name ?? ''); ?>

                    <?php if($info->district && $info->province): ?>, <?php endif; ?>
                    <?php echo e(optional($info->province)->name ?? ''); ?>

                <?php else: ?>
                    —
                <?php endif; ?>
            </div>
        </div>

        <!-- Current Address -->
        <div class="address-card">
            <h6>
                <i class="fas fa-map-pin me-2"></i>
                អាសយដ្ឋានបច្ចុប្បន្ន
            </h6>
            <div class="address-text">
                <?php if($info->currentVillage || $info->currentCommune || $info->currentDistrict || $info->currentProvince): ?>
                    <?php echo e(optional($info->currentVillage)->name ?? ''); ?>

                    <?php if($info->currentVillage && $info->currentCommune): ?>, <?php endif; ?>
                    <?php echo e(optional($info->currentCommune)->name ?? ''); ?>

                    <?php if($info->currentCommune && $info->currentDistrict): ?>, <?php endif; ?>
                    <?php echo e(optional($info->currentDistrict)->name ?? ''); ?>

                    <?php if($info->currentDistrict && $info->currentProvince): ?>, <?php endif; ?>
                    <?php echo e(optional($info->currentProvince)->name ?? ''); ?>

                <?php else: ?>
                    —
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php /**PATH D:\monkManagment\resources\views/User/partials/detail-content.blade.php ENDPATH**/ ?>