<!DOCTYPE html>
<html lang="km" dir="ltr" data-bs-theme="light">
<head>
    <meta charset="utf-8" />
    <title>ព័ត៌មានលម្អិត | <?php echo e($userinfo->name_kh); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
    <link href="https://fonts.googleapis.com/css2?family=Kantumruy+Pro:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root { --primary: #4c5cff; --muted: #6b7280; }
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { min-height: 100vh; font-family: 'Kantumruy Pro', system-ui, sans-serif; background: linear-gradient(135deg, #f0f4ff, #faf5ff); }
        .page { padding: 1rem; max-width: 900px; margin: 0 auto; }
        .student-card { background: rgba(255,255,255,0.95); border-radius: 20px; padding: 1.5rem; box-shadow: 0 20px 50px rgba(27,39,92,0.1); margin-top: 2rem; }
        .card-header { display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 1rem; margin-bottom: 1.5rem; padding-bottom: 1rem; border-bottom: 2px solid #f0f0f0; }
        .card-header h3 { font-size: 1.5rem; color: #1f2937; }
        .header-buttons { display: flex; gap: 0.75rem; align-items: center; flex-wrap: wrap; }
        .btn { padding: 0.75rem 1.5rem; border-radius: 12px; font-size: 0.95rem; font-weight: 600; text-decoration: none; border: none; cursor: pointer; transition: all 0.2s; display: inline-block; }
        .btn-primary { background: var(--primary); color: white; }
        .btn-primary:hover { background: #3b4acc; transform: translateY(-2px); box-shadow: 0 4px 12px rgba(76,92,255,0.3); }
        .btn-secondary { background: #f3f4f6; color: #374151; }
        .btn-secondary:hover { background: #e5e7eb; }
        .profile-photo-section { text-align: center; margin-bottom: 2rem; }
        .profile-photo { width: 150px; height: 150px; border-radius: 50%; object-fit: cover; border: 4px solid var(--primary); box-shadow: 0 8px 24px rgba(76,92,255,0.2); }
        .fieldset { margin-bottom: 2rem; }
        .fieldset-title { margin-bottom: 1rem; }
        .fieldset-title h4 { font-size: 1.2rem; color: #1f2937; margin-bottom: 0.25rem; }
        .fieldset-title p { font-size: 0.9rem; color: var(--muted); }
        .field-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1.25rem; }
        .field { display: flex; flex-direction: column; }
        .field span { font-size: 0.85rem; color: var(--muted); margin-bottom: 0.35rem; font-weight: 500; }
        .field-value {
            font-size: 1rem;
            color: #1f2937;
            background: #f9fafb;
            padding: 0.75rem 1rem;
            border-radius: 10px;
            border: 1px solid #e5e7eb;
        }
        
        /* QR Modal Styles */
        .qr-modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.6);
            backdrop-filter: blur(4px);
            animation: fadeIn 0.3s ease;
        }
        
        .qr-modal-content {
            background-color: white;
            margin: 10% auto;
            padding: 2rem;
            border-radius: 20px;
            width: 90%;
            max-width: 400px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            position: relative;
            animation: slideIn 0.3s ease;
        }
        
        .qr-modal-close {
            position: absolute;
            right: 1.5rem;
            top: 1.5rem;
            color: #9ca3af;
            font-size: 2rem;
            font-weight: bold;
            cursor: pointer;
            transition: color 0.2s;
            line-height: 1;
        }
        
        .qr-modal-close:hover {
            color: #1f2937;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        
        @keyframes slideIn {
            from { 
                transform: translateY(-50px);
                opacity: 0;
            }
            to { 
                transform: translateY(0);
                opacity: 1;
            }
        }
        
        @media (max-width: 768px) {
            .student-card { padding: 1rem; border-radius: 16px; }
            .card-header { flex-direction: column; align-items: flex-start; }
            .field-grid { grid-template-columns: 1fr; }
            .qr-modal-content {
                margin: 20% auto;
                padding: 1.5rem;
                width: 95%;
            }
        }
        @media (max-width: 480px) {
            .page { padding: 0.75rem; }
            .student-card { padding: 0.75rem; border-radius: 12px; }
            .header-buttons { width: 100%; }
            .btn { width: 100%; text-align: center; }
            .qr-modal-content {
                margin: 30% auto;
                padding: 1.25rem;
            }
        }
    </style>
</head>
<body>
    <div class="page">
        <?php if(session('success')): ?>
            <div style="background: #10b981; color: white; padding: 1rem 1.5rem; border-radius: 12px; margin-bottom: 1rem; font-weight: 500; box-shadow: 0 4px 12px rgba(16,185,129,0.2);">
                ✓ <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>
        <article class="student-card">
            <div class="card-header">
                <div>
                    <h3>ព័ត៌មានលម្អិត | <?php echo e($userinfo->name_kh); ?></h3>
                </div>
                <div class="header-buttons">
                    <button onclick="toggleQRCode()" class="btn btn-secondary">
                        📱 QR សម្រាប់អ្នក
                    </button>
                   
                    <a href="<?php echo e(URL::signedRoute('profile.edit', ['id' => $userinfo->id])); ?>" class="btn btn-secondary">
                        ✏ កែប្រែ
                    </a>
                </div>
            </div>

            <!-- QR Code Modal -->
            <div id="qrModal" class="qr-modal" onclick="closeQRModal()">
                <div class="qr-modal-content" onclick="event.stopPropagation()">
                    <span class="qr-modal-close" onclick="closeQRModal()">&times;</span>
                    <h4 style="margin-bottom: 1.5rem; color: #1f2937; text-align: center;">ស្កេន QR Code ដើម្បីមើលព័ត៌មាន</h4>
                    <div id="qrcode" style="display: flex; justify-content: center; padding: 1rem; background: white; border-radius: 12px; box-shadow: 0 4px 12px rgba(0,0,0,0.1); margin-bottom: 1rem;"></div>
                    <p style="text-align: center; color: #6b7280; font-size: 0.9rem; margin-bottom: 1.5rem;">ស្កេនកូដនេះដើម្បីចូលមើលព័ត៌មានលម្អិតរបស់អ្នក</p>
                    <button onclick="downloadQRCode()" class="btn btn-primary" style="width: 100%;">
                        📥 ទាញយក QR Code
                    </button>
                </div>
            </div>

            <div class="profile-photo-section">
                <?php if($userinfo->image): ?>
                    <img src="<?php echo e(asset('storage/' . $userinfo->image)); ?>" alt="<?php echo e($userinfo->name_kh); ?>" class="profile-photo">
                <?php else: ?>
                    <img src="https://ui-avatars.com/api/?name=<?php echo e(urlencode($userinfo->name_kh)); ?>&background=4c5cff&color=fff&size=150" alt="<?php echo e($userinfo->name_kh); ?>" class="profile-photo">
                <?php endif; ?>
            </div>

            <div class="fieldset">
                <div class="fieldset-title">
                    <h4>ព័ត៌មានផ្ទាល់ខ្លួន</h4>
                    <p>អត្តសញ្ញាណ និងព័ត៌មានផ្ទាល់ខ្លួនទាំងអស់</p>
                </div>
                <div class="field-grid">
                    <div class="field">
                        <span>អត្តលេខ (ID Number)</span>
                        <div class="field-value"><?php echo e($userinfo->id_number ?? '-'); ?></div>
                    </div>
                    <div class="field">
                        <span>ឈ្មោះ (អក្សរខ្មែរ)</span>
                        <div class="field-value"><?php echo e($userinfo->name_kh); ?></div>
                    </div>
                    <div class="field">
                        <span>ឈ្មោះ (អក្សរឡាតាំង)</span>
                        <div class="field-value"><?php echo e($userinfo->name_en ?? '-'); ?></div>
                    </div>
                    <div class="field">
                        <span>ភិក្ខុ/សាមណេរ</span>
                        <div class="field-value"><?php echo e(optional($userinfo->monkType)->name ?? '-'); ?></div>
                    </div>
                    <?php if($userinfo->dob): ?>
                        <div class="field">
                            <span>ថ្ងៃខែឆ្នាំកំណើត</span>
                            <div class="field-value"><?php echo e(\Carbon\Carbon::parse($userinfo->dob)->format('d/m/Y')); ?></div>
                        </div>
                    <?php endif; ?>
                    <?php if($userinfo->phone_number): ?>
                        <div class="field">
                            <span>លេខទូរស័ព្ទ</span>
                            <div class="field-value"><?php echo e($userinfo->phone_number); ?></div>
                        </div>
                    <?php endif; ?>
                    <?php if($userinfo->kudi): ?>
                        <div class="field">
                            <span>កុដិ</span>
                            <div class="field-value"><?php echo e($userinfo->kudi->kudi_number); ?></div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="fieldset">
                <div class="fieldset-title">
                    <h4>ទីកន្លែងកំណើត</h4>
                    <p>សូមបំពេញរាយនាមតាមលំដាប់រដ្ឋបាល</p>
                </div>
                <div class="field-grid">
                    <?php if(optional($userinfo->province)->name): ?>
                        <div class="field">
                            <span>ខេត្ត/ក្រុង</span>
                            <div class="field-value"><?php echo e($userinfo->province->name); ?></div>
                        </div>
                    <?php else: ?>
                        <div class="field">
                            <span>ខេត្ត/ក្រុង</span>
                            <div class="field-value">-</div>
                        </div>
                    <?php endif; ?>
                    <?php if(optional($userinfo->district)->name): ?>
                        <div class="field">
                            <span>ស្រុក/ខណ្ឌ</span>
                            <div class="field-value"><?php echo e($userinfo->district->name); ?></div>
                        </div>
                    <?php else: ?>
                        <div class="field">
                            <span>ស្រុក/ខណ្ឌ</span>
                            <div class="field-value">-</div>
                        </div>
                    <?php endif; ?>
                    <?php if(optional($userinfo->commune)->name): ?>
                        <div class="field">
                            <span>ឃុំ/សង្កាត់</span>
                            <div class="field-value"><?php echo e($userinfo->commune->name); ?></div>
                        </div>
                    <?php else: ?>
                        <div class="field">
                            <span>ឃុំ/សង្កាត់</span>
                            <div class="field-value">-</div>
                        </div>
                    <?php endif; ?>
                    <?php if(optional($userinfo->village)->name): ?>
                        <div class="field">
                            <span>ភូមិ</span>
                            <div class="field-value"><?php echo e($userinfo->village->name); ?></div>
                        </div>
                    <?php else: ?>
                        <div class="field">
                            <span>ភូមិ</span>
                            <div class="field-value">-</div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="fieldset">
                <div class="fieldset-title">
                    <h4>អាសយដ្ឋានបច្ចុប្បន្ន</h4>
                    <p>ទីកន្លែងបច្ចុប្បន្នរបស់អ្នក</p>
                </div>
                <div class="field-grid">
                    <?php if($userinfo->temple_name): ?>
                        <div class="field">
                            <span>ឈ្មោះវត្ត</span>
                            <div class="field-value"><?php echo e($userinfo->temple_name); ?></div>
                        </div>
                    <?php endif; ?>
                    <?php if(optional($userinfo->currentProvince)->name): ?>
                        <div class="field">
                            <span>ខេត្ត/ក្រុង</span>
                            <div class="field-value"><?php echo e($userinfo->currentProvince->name); ?></div>
                        </div>
                    <?php else: ?>
                        <div class="field">
                            <span>ខេត្ត/ក្រុង</span>
                            <div class="field-value">-</div>
                        </div>
                    <?php endif; ?>
                    <?php if(optional($userinfo->currentDistrict)->name): ?>
                        <div class="field">
                            <span>ស្រុក/ខណ្ឌ</span>
                            <div class="field-value"><?php echo e($userinfo->currentDistrict->name); ?></div>
                        </div>
                    <?php else: ?>
                        <div class="field">
                            <span>ស្រុក/ខណ្ឌ</span>
                            <div class="field-value">-</div>
                        </div>
                    <?php endif; ?>
                    <?php if(optional($userinfo->currentCommune)->name): ?>
                        <div class="field">
                            <span>ឃុំ/សង្កាត់</span>
                            <div class="field-value"><?php echo e($userinfo->currentCommune->name); ?></div>
                        </div>
                    <?php else: ?>
                        <div class="field">
                            <span>ឃុំ/សង្កាត់</span>
                            <div class="field-value">-</div>
                        </div>
                    <?php endif; ?>
                    <?php if(optional($userinfo->currentVillage)->name): ?>
                        <div class="field">
                            <span>ភូមិ</span>
                            <div class="field-value"><?php echo e($userinfo->currentVillage->name); ?></div>
                        </div>
                    <?php else: ?>
                        <div class="field">
                            <span>ភូមិ</span>
                            <div class="field-value">-</div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="fieldset">
                <div class="fieldset-title">
                    <h4>ព័ត៌មានមាតាបិតា</h4>
                    <p>ព័ត៌មានអំពីមាតាបិតារបស់អ្នក</p>
                </div>
                <div class="field-grid">
                    <?php if($userinfo->father_name): ?>
                        <div class="field">
                            <span>ឈ្មោះឪពុក</span>
                            <div class="field-value"><?php echo e($userinfo->father_name); ?></div>
                            <?php if($userinfo->father_job): ?>
                                <div class="field-value" style="font-size: 0.9rem; color: var(--muted); margin-top: 0.25rem;">
                                    មុខរបរ: <?php echo e($userinfo->father_job); ?>

                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    <?php if($userinfo->mother_name): ?>
                        <div class="field">
                            <span>ឈ្មោះម្តាយ</span>
                            <div class="field-value"><?php echo e($userinfo->mother_name); ?></div>
                            <?php if($userinfo->mother_job): ?>
                                <div class="field-value" style="font-size: 0.9rem; color: var(--muted); margin-top: 0.25rem;">
                                    មុខរបរ: <?php echo e($userinfo->mother_job); ?>

                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="fieldset">
                <div class="fieldset-title">
                    <h4>ព័ត៌មានការសិក្សា</h4>
                    <p>កម្រិតវប្បធម៌និងការសិក្សារបស់អ្នក</p>
                </div>
                <div class="field-grid">
                    <?php if(optional($userinfo->education)->name): ?>
                        <div class="field">
                            <span>កម្រិតវប្បធម៌</span>
                            <div class="field-value"><?php echo e($userinfo->education->name); ?></div>
                        </div>
                    <?php endif; ?>
                    <?php if(optional($userinfo->educationYear)->name): ?>
                        <div class="field">
                            <span>ឆ្នាំសិក្សា</span>
                            <div class="field-value"><?php echo e($userinfo->educationYear->name); ?></div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </article>
    </div>

    <!-- QR Code Library -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
    <script>
        let qrCodeGenerated = false;
        const profileUrl = "<?php echo e(URL::signedRoute('profile.public', ['id' => $userinfo->id])); ?>";

        function toggleQRCode() {
            const modal = document.getElementById('qrModal');
            modal.style.display = 'block';
            document.body.style.overflow = 'hidden';
            
            // Generate QR code only once
            if (!qrCodeGenerated) {
                document.getElementById('qrcode').innerHTML = '';
                new QRCode(document.getElementById('qrcode'), {
                    text: profileUrl,
                    width: 200,
                    height: 200,
                    colorDark: "#4c5cff",
                    colorLight: "#ffffff",
                    correctLevel: QRCode.CorrectLevel.H
                });
                qrCodeGenerated = true;
            }
        }

        function closeQRModal() {
            const modal = document.getElementById('qrModal');
            modal.style.display = 'none';
            document.body.style.overflow = 'auto';
        }

        function downloadQRCode() {
            const qrCanvas = document.querySelector('#qrcode canvas');
            if (qrCanvas) {
                const link = document.createElement('a');
                link.download = 'profile-qrcode-<?php echo e($userinfo->id_number); ?>.png';
                link.href = qrCanvas.toDataURL();
                link.click();
            }
        }

        // Close modal when pressing Escape key
        document.addEventListener('keydown', function(event) {
            if (event.key === 'Escape') {
                closeQRModal();
            }
        });
    </script>
</body>
</html>
<?php /**PATH D:\monkManagment\resources\views/User/public-profile.blade.php ENDPATH**/ ?>