@extends('admin.components.app')
@section('content')
    <div class="page">
       <form class="register-form"
      action="{{ isset($vil->id) ? route('village.edit', $vil->id) : route('village.create') }}"
      method="post">
    @csrf

    <article class="student-card">
        <div class="fieldset">
            <div class="field-grid">

                <label class="field">
                    <span>ឈ្មោះភូមិ (Village Name)</span>
                    <input type="text" name="name" value="{{ old('name', $vil->name ?? '') }}" required>
                </label>

                <div class="field">
                    <span>ជ្រើសរើសឃុំ (Select Commune)</span>
                    <select name="commune_id" class="form-control" required>
                        <option value="">-- Select district --</option>
                        @foreach ($com as $p)
                            <option value="{{ $p->id }}"
                                {{ (old('commune_id', $vil->commune_id ?? '') == $p->id) ? 'selected' : '' }}>
                                {{ $p->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

            </div>
        </div>

        <div class="form-footer">
            <button class="btn btn-outline" type="reset">សម្អាតទិន្នន័យ</button>
            <button class="btn btn-primary" type="submit">
                {{ isset($vil->id) ? 'កែប្រែ (Update)' : 'រក្សាទុក (Save)' }}
            </button>
        </div>
    </article>
</form>
    </div>
@endsection
