@forelse ($users as $i => $user)
    <tr data-kudi-id="{{ $user->kudi_id ?? '' }}">
        <th>{{ $i + 1 }}</th>
        <td class="ps-0">
            <img src="{{ $user->image ? Storage::url($user->image) : 'assets/image/—Pngtree—kon chat buddhism_6948880.png' }}" 
                 alt="{{ $user->name }}"
                 class="avatar-fit"
                 onclick="openUserImageModal(this, '{{ $user->name }}')"
                 style="cursor: pointer; transition: transform 0.3s ease;"
                 onmouseover="this.style.transform='scale(1.1)'"
                 onmouseout="this.style.transform='scale(1)'">
        </td>
        <td>{{ $user->name }}</td>
        <td>{{ optional($user->kudi)->kudi_number ?? '—' }}</td>
        <td>{{ $user->role }}</td>
        @include('admin.user.action', ['user' => $user])
    </tr>
@empty
    <tr>
        <td colspan="6" class="text-center py-4">
            <div class="empty-state-container">
                <div class="empty-state-content">
                    <i class="fas fa-users fa-4x text-muted mb-3"></i>
                    <h5 class="text-muted mb-2">មិនមានទិន្នន័យអ្នកប្រើប្រាស់</h5>
                    <p class="text-muted mb-2">មិនមានទិន្នន័យអ្នកប្រើប្រាស់នៅឡើយទេ។</p>
                    <small class="text-muted">(No user data available for this kudi)</small>
                </div>
            </div>
        </td>
    </tr>
@endforelse
    <style>
    .empty-state-container {
        padding: 3rem 2rem;
        min-height: 200px;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        border-radius: 18px;
        box-shadow: 0 10px 25px rgba(118, 127, 180, 0.12);
        margin: 0.5rem;
    }
    
    .empty-state-content {
        text-align: center;
    }
    
    .empty-state-container i {
        opacity: 0.6;
        transition: all 0.3s ease;
    }
    
    .empty-state-container:hover i {
        opacity: 0.8;
        transform: scale(1.05);
    }
    
    .empty-state-container h5 {
        font-weight: 600;
        color: #6c7798;
    }
    
    .empty-state-container p {
        font-size: 0.95rem;
        color: #8a92a6;
    }
    
    .empty-state-container small {
        font-size: 0.85rem;
        color: #9ca3af;
        font-style: italic;
    }
    </style>
