@extends('admin.components.app')

@section('content')
    <div class="page">
        <!-- Quick Navigation -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h3 class="mb-1">{{ isset($user) ? 'កែប្រែអ្នកប្រើប្រាស់' : 'បង្កើតអ្នកប្រើប្រាស់ថ្មី' }}</h3>
                <p class="text-muted mb-0">{{ isset($user) ? 'កែប្រែព័ត៌មានអ្នកប្រើប្រាស់' : 'បញ្ចូលព័ត៌មានអ្នកប្រើប្រាស់ថ្មី' }}</p>
            </div>
            <div>
                <a href="{{ route('dashboard.index') }}" class="btn btn-outline-primary">
                    <i class="iconoir-home me-1"></i>
                    Dashboard
                </a>
                <a href="{{ route('user.index') }}" class="btn btn-outline-secondary ms-2">
                    <i class="iconoir-arrow-left me-1"></i>
                    ត្រឡប់ទៅបញ្ជី
                </a>
            </div>
        </div>
        
        <section class="form-section" id="register">
            <form class="register-form" action="{{ isset($user) ? route('user.edit', $user->id) : route('user.create') }}"
                method="post" enctype="multipart/form-data">
                @csrf
                <article class="student-card">
                    <div class="fieldset">
                        <div class="fieldset-title">
                            <h4>ព័ត៌មានផ្ទាល់ខ្លួន</h4>
                            <p>អត្តសញ្ញាណ និងព័ត៌មានផ្ទាល់ខ្លួនទាំងអស់</p>
                        </div>
                        <div class="field-grid">
                            <label class="field">
                                <span>ឈ្មោះ (អក្សរឡាតាំង)</span>
                                <input type="text" name="name" value="{{ old('name', $user->name ?? '') }}">
                            </label>
                            
                            <label class="field">
                                <span>តួនាទី</span>
                                <select name="role" class="form-control" required>
                                    <option value="">-- ជ្រើសរើសតួនាទី --</option>
                                    <option value="admin" {{ (isset($user) && $user->role == 'admin') || old('role') == 'admin' ? 'selected' : '' }}>
                                        admin
                                    </option>
                                    <option value="super_admin" {{ (isset($user) && $user->role == 'super_admin') || old('role') == 'super_admin' ? 'selected' : '' }}>
                                        super_admin
                                    </option>
                                </select>
                            </label>
                            <label class="field">
                                <span>ពាក្យសម្ងាត់ {{ isset($user) ? '(ទុកទទេបើមិនចង់ផ្លាស់ប្តូរ)' : '' }}</span>
                                <input type="password" name="password" placeholder="{{ isset($user) ? '••••••••' : 'បញ្ចូលពាក្យសម្ងាត់' }}">
                            </label>
                           
                
                            @if (!isset($user) || $user->role != 'super_admin')
                            <label for="" class="field">
                                <span>ជ្រើសរើសកុដិ</span>
                                <select name="kudi_id" class="form-control" {{ (!isset($user) || old('role', $user->role ?? '') != 'super_admin') ? 'required' : '' }}>
                                    <option value="">-- ជ្រើសរើសកុដិ --</option>
                                    @foreach ($kudi as $item)
                                        <option value="{{ $item->id }}"
                                            {{ (isset($user) && $user->kudi_id == $item->id) || old('kudi_id') == $item->id ? 'selected' : '' }}>
                                            {{ $item->kudi_number }}
                                        </option>
                                    @endforeach
                                </select>

                            </label>
                            @else
                            <input type="hidden" name="kudi_id" value="">
                            @endif
                            @if (isset($user) && $user->image)
                                <div class="field">
                                    <span>Current Image:</span>
                                    <img src="{{ Storage::url($user->image) }}" alt=""
                                        style="width: 100px; height: 100px; object-fit: cover;">
                                </div>
                            @endif
                            <label class="field">
                                <span>រូបភាព</span>
                                <input type="file" name="image">
                            </label>

                        </div>
                    </div>
                    <div>
                        @if(session('success'))
                            <p class="text-sucess">{{ session('success') }}</p>
                        @endif
                        @if($errors->any())
           
                        
                            @foreach($errors->all() as $error)
                            <p class="text-danger">  {{ $error }}</p>
                            @endforeach
                        
                             @endif
                    </div>
                    <div class="form-footer">
                        <button class="btn btn-outline" type="reset">សម្អាតទិន្នន័យ</button>
                        <button class="btn btn-primary" type="submit">{{ isset($user) ? 'កែប្រែ' : 'រក្សាទុក' }}</button>
                    </div>
                </article>
            </form>
        </section>
    </div>
@endsection
