<div class="user-detail-modal">
    <!-- Header Section -->
    <div class="modal-header">
        <div class="user-avatar-section">
            <img src="{{ $user->image ? Storage::url($user->image) : 'assets/image/—Pngtree—kon chat buddhism_6948880.png' }}" 
                 alt="{{ $user->name }}" 
                 class="user-avatar">
        </div>
        <div class="user-info-section">
            <h2 class="user-name-kh">{{ $user->name }}</h2>
            <p class="user-name-en">{{ $user->name_en ?? '—' }}</p>
            <div class="user-badges">
                <span class="badge monk-type">{{ $user->role ?? 'User' }}</span>
                <span class="badge kudi-number">{{ optional($user->kudi)->kudi_number ?? 'N/A' }}</span>
            </div>
        </div>
    </div>

    <!-- Content Sections -->
    <div class="modal-content">
        <!-- Personal Information -->
        <div class="info-section">
            <div class="section-header">
                <i class="fas fa-user-circle"></i>
                <h3>ព័ត៌មានផ្ទាល់ខ្លួន</h3>
            </div>
            <div class="info-list">
                <div class="info-item">
                    <span class="info-label">ឈ្មោះ</span>
                    <span class="info-value">{{ $user->name }}</span>
                </div>
                <div class="info-item">
                    <span class="info-label">តួនាទី</span>
                    <span class="info-value">{{ $user->role }}</span>
                </div>
                <div class="info-item">
                    <span class="info-label">កុដិ</span>
                    <span class="info-value">{{ optional($user->kudi)->kudi_number ?? '—' }}</span>
                </div>
                @if($user->email)
                <div class="info-item">
                    <span class="info-label">អ៊ីមែល</span>
                    <span class="info-value">{{ $user->email }}</span>
                </div>
                @endif
            </div>
        </div>

        <!-- System Information -->
        <div class="info-section">
            <div class="section-header">
                <i class="fas fa-cog"></i>
                <h3>ព័ត៌មានប្រព័ន្ធ</h3>
            </div>
            <div class="info-list">
                <div class="info-item">
                    <span class="info-label">បង្កើតនៅ</span>
                    <span class="info-value">{{ $user->created_at ? $user->created_at->format('d/m/Y H:i') : '—' }}</span>
                </div>
                <div class="info-item">
                    <span class="info-label">ធ្វើបច្ចុប្បន្នភាព</span>
                    <span class="info-value">{{ $user->updated_at ? $user->updated_at->format('d/m/Y H:i') : '—' }}</span>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.user-detail-modal {
    background: white;
    border-radius: 16px;
    overflow: hidden;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
    max-height: 85vh;
    overflow-y: auto;
}

.modal-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    padding: 24px;
    display: flex;
    align-items: center;
    gap: 20px;
}

.user-avatar-section {
    flex-shrink: 0;
}

.user-avatar {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    object-fit: cover;
    border: 3px solid rgba(255, 255, 255, 0.9);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
}

.user-info-section {
    flex: 1;
    color: white;
}

.user-name-kh {
    font-size: 1.5rem;
    font-weight: 700;
    margin: 0 0 4px 0;
    text-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
}

.user-name-en {
    font-size: 1rem;
    margin: 0 0 12px 0;
    opacity: 0.9;
    font-style: italic;
}

.user-badges {
    display: flex;
    gap: 8px;
    flex-wrap: wrap;
}

.badge {
    padding: 6px 12px;
    border-radius: 20px;
    font-size: 0.75rem;
    font-weight: 600;
    backdrop-filter: blur(10px);
    background: rgba(255, 255, 255, 0.2);
    color: white;
    border: 1px solid rgba(255, 255, 255, 0.3);
}

.modal-content {
    background: white;
    padding: 0;
}

.info-section {
    border-bottom: 1px solid #f0f0f0;
}

.info-section:last-child {
    border-bottom: none;
}

.section-header {
    padding: 16px 24px;
    display: flex;
    align-items: center;
    gap: 12px;
    background: #f8f9fa;
    border-bottom: 1px solid #e9ecef;
}

.section-header i {
    color: #667eea;
    font-size: 1.1rem;
}

.section-header h3 {
    margin: 0;
    font-size: 1rem;
    font-weight: 600;
    color: #333;
}

.info-list {
    padding: 0;
}

.info-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 12px 24px;
    border-bottom: 1px solid #f8f9fa;
    transition: background-color 0.2s ease;
}

.info-item:last-child {
    border-bottom: none;
}

.info-item:hover {
    background-color: #f8f9fa;
}

.info-label {
    font-weight: 600;
    color: #666;
    font-size: 0.9rem;
}

.info-value {
    color: #333;
    font-weight: 500;
    font-size: 0.9rem;
    text-align: right;
}

/* Scrollbar styling */
.user-detail-modal::-webkit-scrollbar {
    width: 6px;
}

.user-detail-modal::-webkit-scrollbar-track {
    background: #f1f1f1;
}

.user-detail-modal::-webkit-scrollbar-thumb {
    background: #888;
    border-radius: 3px;
}

.user-detail-modal::-webkit-scrollbar-thumb:hover {
    background: #555;
}

/* Responsive Design */
@media (max-width: 768px) {
    .modal-header {
        flex-direction: column;
        text-align: center;
        padding: 20px;
        gap: 16px;
    }
    
    .user-avatar {
        width: 70px;
        height: 70px;
    }
    
    .user-name-kh {
        font-size: 1.3rem;
    }
    
    .user-badges {
        justify-content: center;
    }
    
    .info-item {
        flex-direction: column;
        align-items: flex-start;
        gap: 4px;
        padding: 16px 24px;
    }
    
    .info-value {
        text-align: left;
    }
}
</style>
