@extends('admin.components.app')
@section('content')

    <div class="page">
        <section class="form-section">
            <div class="card mt-3 border-0 shadow-none bg-transparent">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h3 class="mb-0">បញ្ជីអ្នកប្រើប្រាស់</h3>
                    <a href="{{ route('mother.create') }}" class="btn btn-primary">បង្កើតថ្មី</a>
                </div>

                <div class="table-wrapper">
                    <table class="table table-hover align-middle mb-0 checkbox-all" id="datatable_1">
                        <thead>
                            <tr>
                                <th>ល.រ</th>
                                <th>ឈ្មោះ</th>
                                <th>ការងារ</th>
                                <th>ខេត្ត</th>
                                <th>ក្រុង</th>
                                <th>ឃុំ</th>
                                <th>ភូមិ</th>

                                <th class="text-end">សកម្មភាព</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($mother as $i => $mother)
                                <tr>
                                    <th>{{ $i + 1 }}</th>
                                    <td class="ps-0">
                                        {{ $mother->name }}
                                    </td>
                                    <td>{{ $mother->job }}</td>
                                    <td>{{ $mother->province->name }}</td>
                                    <td>{{ $mother->district->name }}</td>
                                    <td>{{ $mother->commune->name }}</td>
                                    <td>{{ $mother->village->name }}</td>

                                    @include('admin.mother.action', ['mother' => $mother])
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </section>
    </div>

@endsection
