@extends('admin.components.app')
@section('content')

@push('script')
    <script src="{{ asset('assets/js/kudi-filter.js') }}"></script>
@endpush

    <div class="page">
        <section class="form-section">
            <div class="card mt-3 border-0 shadow-none bg-transparent">
                @include('admin.components.kudi-filter', [
                    'title' => 'បញ្ជីប្រភេទ',
                    'subtitle' => 'រើសប្រភេទតាមកុដិ',
                    'filterLabel' => 'ស្រែប្រភេទ',
                    'filterAction' => route('monktype.index'),
                    'kudis' => $kudis,
                    'selectedKudiId' => request('kudi_id'),
                    'createRoute' => route('monktype.create'),
                    'createLabel' => 'បង្កើតប្រភេទថ្មី'
                ])

                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h3 class="mb-0">បញ្ជីអ្នកប្រើប្រាស់</h3>
                    <a href="{{ route('monktype.create') }}" class="btn btn-primary">បង្កើតថ្មី</a>
                </div>

                <div class="table-wrapper">
                    <table class="table table-hover align-middle mb-0 checkbox-all" id="datatable_1">
                        <thead>
                            <tr>
                                <th>ល.រ</th>
                                 <th>ប្រភេទ</th>
                                 
                                <th class="text-end">សកម្មភាព</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($monktype as $i => $monktype)
                                <tr>
                                    <th>{{ $i + 1 }}</th>

                                    <td>{{ $monktype->name }}</td>
                                    

                                    @include('admin.monktype.action', ['monktype' => $monktype])
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </section>
    </div>

@endsection
