@extends('admin.components.app')
@section('content')
    <div class="page">
        <section class="form-section" id="register">
            <form class="register-form" data-location-form
                action="{{ $father->exists ? route('father.edit', $father->id) : route('father.create') }}" method="POST"
                enctype="multipart/form-data">
                @csrf
                <article class="student-card">
                    <div class="fieldset">
                        <div class="fieldset-title">
                            <h4>ព័ត៌មានផ្ទាល់ខ្លួន</h4>
                            <p>អត្តសញ្ញាណ និងព័ត៌មានផ្ទាល់ខ្លួនទាំងអស់</p>
                        </div>
                        <div class="field-grid">

                            <label class="field">
                                <span>ឈ្មោះពេញ (អក្សរខ្មែរ)</span>
                                <input type="text" name="name" value="{{ old('name', $father->name ?? '') }}">
                            </label>

                            <label class="field">
                                <span>ការងារ</span>
                                <input type="text" name="job" value="{{ old('job', $father->job ?? '') }}">
                            </label>

                            <label for="" class="field">
                                <span>ខេត្ត</span>
                                <select name="province_id" class="form-control" data-role="province"
                                    data-placeholder="Select Province" required>
                                    <option value="">{{ __('Select Province') }}</option>
                                    @foreach ($pro as $row)
                                        <option value="{{ $row->id }}"
                                            {{ old('province_id', $father->province_id) == $row->id ? 'selected' : '' }}>
                                            {{ $row->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </label>
                            <label class="field">
                                <span>ស្រុក</span>
                                <select name="district_id" class="form-control field" data-role="district"
                                    data-endpoint="{{ url('/locations/provinces/:id/districts') }}"
                                    data-placeholder="Select District" data-disabled-placeholder="Select Province first"
                                    {{ old('province_id', $father->province_id) ? '' : 'disabled' }} required>
                                    <option value="">
                                        {{ old('province_id', $father->province_id) ? 'Select District' : 'Select Province first' }}
                                    </option>
                                    @foreach ($dis as $row)
                                        <option value="{{ $row->id }}"
                                            {{ old('district_id', $father->district_id) == $row->id ? 'selected' : '' }}>
                                            {{ $row->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </label>

                            <label class="field">
                                <span>ឃុំ/សង្កាត់</span>
                                <select name="commune_id" class="form-control field" data-role="commune"
                                    data-endpoint="{{ url('/locations/districts/:id/communes') }}"
                                    data-placeholder="Select Commune" data-disabled-placeholder="Select District first"
                                    {{ old('district_id', $father->district_id) ? '' : 'disabled' }} required>
                                    <option value="">
                                        {{ old('district_id', $father->district_id) ? 'Select Commune' : 'Select District first' }}
                                    </option>
                                    @foreach ($com as $row)
                                        <option value="{{ $row->id }}"
                                            {{ old('commune_id', $father->commune_id) == $row->id ? 'selected' : '' }}>
                                            {{ $row->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </label>

                            <label class="field">
                                <span>ភូមិ</span>
                                <select name="village_id" class="form-control field" data-role="village"
                                    data-endpoint="{{ url('/locations/communes/:id/villages') }}"
                                    data-placeholder="Select Village" data-disabled-placeholder="Select Commune first"
                                    {{ old('commune_id', $father->commune_id) ? '' : 'disabled' }} required>
                                    <option value="">
                                        {{ old('commune_id', $father->commune_id) ? 'Select Village' : 'Select Commune first' }}
                                    </option>
                                    @foreach ($vil as $row)
                                        <option value="{{ $row->id }}"
                                            {{ old('village_id', $father->village_id) == $row->id ? 'selected' : '' }}>
                                            {{ $row->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </label>
                        </div>
                    </div>

                    <div class="form-footer">
                        <button class="btn btn-outline" type="reset">សម្អាតទិន្នន័យ</button>
                        <button class="btn btn-primary" type="submit">{{ $father->exists ? 'កែប្រែ' : 'រក្សាទុក' }}</button>
                    </div>
                </article>
            </form>
        </section>
    </div>
@endsection

@push('script')
    @include('admin.components.location-select-script')
@endpush
