@extends('admin.components.app')
@section('content')
    <div class="page">
        <form class="register-form"
            action="{{ isset($eduyear->id) ? route('educationyear.edit', $eduyear->id) : route('educationyear.create') }}"
            method="post">
            @csrf

            <article class="student-card">
                <div class="fieldset">
                    <div class="field-grid">

                        <label class="field">
                            <span>ឆ្នាំសិក្សា (Year)</span>
                            <input type="text" name="name" value="{{ old('name', $eduyear->name ?? '') }}" required>
                        </label>

                        <div class="field">
                            <span>ជ្រើសរើសគ្រឹះសិក្សា (Select Commune)</span>
                            <select name="education_id" class="form-control" required>
                                <option value="">-- Select Education Program --</option>
                                @foreach ($edu as $education)
                                    <option value="{{ $education->id }}"
                                        {{ old('education_id', $eduyear->education_id ?? '') == $education->id ? 'selected' : '' }}>
                                        {{ $education->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                    </div>
                </div>

                <div class="form-footer">
                    <button class="btn btn-outline" type="reset">សម្អាតទិន្នន័យ</button>
                    <button class="btn btn-primary" type="submit">
                        {{ isset($eduyear->id) ? 'កែប្រែ (Update)' : 'រក្សាទុក (Save)' }}
                    </button>
                </div>
            </article>
        </form>
    </div>
@endsection
