@extends('admin.components.app')
@section('content')

    <div class="page">
        <section class="form-section">
            <div class="card mt-3 border-0 shadow-none bg-transparent">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h3 class="mb-0">បញ្ជីអ្នកប្រើប្រាស់</h3>
                    <a href="{{ route('user.create') }}" class="btn btn-primary">បង្កើតថ្មី</a>
                </div>

                <div class="table-wrapper">
                    <table class="table table-hover align-middle mb-0 checkbox-all" id="datatable_1">
                        <thead>
                            <tr>
                                <th>ល.រ</th>
                                <th>រូបភាព</th>
                                <th>ឈ្មោះ</th>
                                <th>អាស័យដ្ឋាន Email</th>
                                <th>តួនាទី</th>
                                <th class="text-end">សកម្មភាព</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($users as $i => $user)
                                <tr>
                                    <th>{{ $i + 1 }}</th>
                                    <td class="ps-0">
                                        <img src="{{ $user->image ? Storage::url($user->image) : asset('assets/image/leader/20230601175524_IMG_4601.JPG') }}" alt=""
                                            class="avatar-fit">
                                    </td>
                                    <td>{{ $user->name }}</td>
                                    <td>{{ $user->email }}</td>
                                    <td>{{ $user->role }}</td>
                                    @include('admin.user.action', ['user' => $user])
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </section>
    </div>

@endsection
