@extends('admin.components.app')
@section('content')
    <div class="page">
       <form class="register-form"
      action="{{ isset($com->id) ? route('commune.edit', $com->id) : route('commune.create') }}"
      method="post">
    @csrf

    <article class="student-card">
        <div class="fieldset">
            <div class="field-grid">

                <label class="field">
                    <span>ឈ្មោះឃុំ (Commune Name)</span>
                    <input type="text" name="name" value="{{ old('name', $com->name ?? '') }}" required>
                </label>

                <div class="field">
                    <span>ជ្រើសរើសស្រុក (Select district)</span>
                    <select name="district_id" class="form-control" required>
                        <option value="">-- Select district --</option>
                        @foreach ($dis as $p)
                            <option value="{{ $p->id }}"
                                {{ (old('district_id', $com->district_id ?? '') == $p->id) ? 'selected' : '' }}>
                                {{ $p->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

            </div>
        </div>

        <div class="form-footer">
            <button class="btn btn-outline" type="reset">សម្អាតទិន្នន័យ</button>
            <button class="btn btn-primary" type="submit">
                {{ isset($dis->id) ? 'កែប្រែ (Update)' : 'រក្សាទុក (Save)' }}
            </button>
        </div>
    </article>
</form>
    </div>
@endsection
