<!DOCTYPE html>
<html lang="km" dir="ltr" data-bs-theme="light">
<head>
    <meta charset="utf-8" />
    <title>ចុះឈ្មោះសមាជិក | Monk Management</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <link href="https://fonts.googleapis.com/css2?family=Kantumruy+Pro:wght@400;500;600;700&family=Space+Grotesk:wght@400;500;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('assets/style/form.css') }}">
    <style>
        :root {
            --primary: #4c5cff;
            --primary-dark: #3644ff;
            --bg: #f0f4ff;
            --bg-2: #faf5ff;
            --surface: rgba(255, 255, 255, 0.85);
            --surface-strong: rgba(255, 255, 255, 0.95);
            --text: #1a1f36;
            --muted: #6b7280;
            --border: rgba(255, 255, 255, 0.6);
            --radius-md: 16px;
            --radius-lg: 24px;
            --shadow: 0 25px 60px rgba(27, 39, 92, 0.12);
            --transition: 0.2s ease;
        }
        
        body {
            margin: 0;
            min-height: 100vh;
            font-family: 'Kantumruy Pro', 'Space Grotesk', system-ui, sans-serif;
            background: radial-gradient(circle at 20% 20%, rgba(173, 204, 255, 0.4), transparent 55%),
                radial-gradient(circle at 80% 0%, rgba(255, 193, 231, 0.5), transparent 40%),
                linear-gradient(120deg, var(--bg), var(--bg-2));
        }
        
        .page-header {
            text-align: center;
            padding: 2rem 1rem;
        }
        
        .page-header h1 {
            font-size: 2rem;
            color: var(--text);
            margin: 0 0 0.5rem;
        }
        
        .page-header p {
            color: var(--muted);
            margin: 0;
        }
        
        .alert {
            padding: 1rem;
            border-radius: 12px;
            margin-bottom: 1rem;
        }
        
        .alert-success {
            background: rgba(34, 197, 94, 0.15);
            color: #166534;
            border: 1px solid rgba(34, 197, 94, 0.3);
        }
        
        .login-link {
            text-align: center;
            margin-top: 1rem;
        }
        
        .login-link a {
            color: var(--primary);
            text-decoration: none;
            font-weight: 600;
        }
        
        .login-link a:hover {
            text-decoration: underline;
        }

        /* Responsive Styles */
        .page { padding: 1rem; max-width: 900px; margin: 0 auto; }
        .student-card { background: var(--surface-strong); border-radius: var(--radius-lg); padding: 1.5rem; box-shadow: var(--shadow); }
        .card-header { display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 1rem; margin-bottom: 1.5rem; }
        .fieldset { margin-bottom: 1.5rem; }
        .field-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1rem; }
        .field { display: flex; flex-direction: column; }
        .field span { font-size: 0.85rem; color: var(--muted); margin-bottom: 0.35rem; }
        .field input, .field select { padding: 0.75rem 1rem; border: 1px solid rgba(0,0,0,0.1); border-radius: 12px; font-size: 1rem; }
        .field-error { color: #dc2626; font-size: 0.85rem; margin-top: 0.35rem; }
        .radio-group { display: flex; flex-wrap: wrap; gap: 0.5rem; }
        .form-actions { display: flex; gap: 1rem; flex-wrap: wrap; }
        .form-actions button { flex: 1; min-width: 150px; padding: 0.85rem 1.5rem; border-radius: 12px; font-size: 1rem; font-weight: 600; cursor: pointer; }

        /* Khmer Flatpickr Styles */
        .flatpickr-calendar {
            font-family: 'Kantumruy Pro', system-ui, sans-serif !important;
        }
        
        .flatpickr-months {
            font-family: 'Kantumruy Pro', system-ui, sans-serif !important;
        }
        
        .flatpickr-months .flatpickr-month,
        .flatpickr-months .flatpickr-year {
            font-family: 'Kantumruy Pro', system-ui, sans-serif !important;
        }
        
        .flatpickr-weekdays {
            font-family: 'Kantumruy Pro', system-ui, sans-serif !important;
        }
        
        .flatpickr-weekdays .flatpickr-weekday {
            font-family: 'Kantumruy Pro', system-ui, sans-serif !important;
        }
        
        .flatpickr-days {
            font-family: 'Kantumruy Pro', system-ui, sans-serif !important;
        }
        
        .flatpickr-days .flatpickr-day {
            font-family: 'Kantumruy Pro', system-ui, sans-serif !important;
        }
        
        .flatpickr-time {
            font-family: 'Kantumruy Pro', system-ui, sans-serif !important;
        }
        
        .flatpickr-time .numInputWrapper {
            font-family: 'Kantumruy Pro', system-ui, sans-serif !important;
        }
        
        .flatpickr-time .numInputWrapper input {
            font-family: 'Kantumruy Pro', system-ui, sans-serif !important;
        }
        
        .flatpickr-time .numInputWrapper span {
            font-family: 'Kantumruy Pro', system-ui, sans-serif !important;
        }
        
        .flatpickr-time .flatpickr-am-pm {
            font-family: 'Kantumruy Pro', system-ui, sans-serif !important;
        }

        /* Tablet */
        @media (max-width: 768px) {
            .page-header h1 { font-size: 1.5rem; }
            .student-card { padding: 1rem; border-radius: 16px; }
            .card-header { flex-direction: column; align-items: flex-start; }
            .field-grid { grid-template-columns: 1fr; }
        }

        /* Mobile */
        @media (max-width: 480px) {
            .page { padding: 0.75rem; }
            .page-header { padding: 1rem 0.5rem; }
            .page-header h1 { font-size: 1.25rem; }
            .student-card { padding: 0.75rem; border-radius: 12px; }
            .fieldset-title h4 { font-size: 1rem; }
            .field input, .field select { padding: 0.65rem 0.85rem; font-size: 0.9rem; }
            .form-actions { flex-direction: column; }
            .form-actions button { width: 100%; }
        }
    </style>
</head>
<body>
    <div class="page">
        <div class="page-header">
            <h1>ចុះឈ្មោះសមាជិកកុដិ</h1>
            <p>សូមបំពេញព័ត៌មានខាងក្រោមដើម្បីចុះឈ្មោះ</p>
        </div>
        
        <section class="form-section" id="register">
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif
            
           
            
            @php
                $provinceId = old('province_id');
                $districtId = old('district_id');
                $communeId = old('commune_id');
                $educationId = old('education_id');
                
                // Current address values
                $currentProvinceId = old('current_province_id');
                $currentDistrictId = old('current_district_id');
                $currentCommuneId = old('current_commune_id');
            @endphp
            <form class="register-form" data-location-form
                action="{{ route('register.public') }}"
                method="post" enctype="multipart/form-data">
                @csrf

                <article class="student-card">
                    <div class="card-header">
                        <div>
                            <h3>សូមបំពេញព័ត៌មានរបស់អ្នក</h3>
                        </div>
                        <span class="status-pill">ចុះឈ្មោះថ្មី</span>
                    </div>

                    <div class="fieldset">
                        <div class="fieldset-title">
                            <h4>ព័ត៌មានផ្ទាល់ខ្លួន</h4>
                            <p>អត្តសញ្ញាណ និងព័ត៌មានផ្ទាល់ខ្លួនទាំងអស់</p>
                        </div>
                        <div class="field-grid">
                            <label class="field">
                                <span>អត្តលេខ (ID Number) *</span>
                                <input type="text" name="id_number" value="{{ old('id_number') }}"
                                    placeholder="012345">
                                @error('id_number')
                                    <div class="field-error">{{ $message }}</div>
                                @enderror
                            </label>
                            <label class="field">
                                <span>ឈ្មោះ (អក្សរខ្មែរ) *</span>
                                <input type="text" name="name_kh" value="{{ old('name_kh') }}"
                                    placeholder="ឧ. សុវណ្ណុ">
                                @error('name_kh')
                                    <div class="field-error">{{ $message }}</div>
                                @enderror
                            </label>
                            <label class="field">
                                <span>ឈ្មោះ (អក្សរឡាតាំង) *</span>
                                <input type="text" name="name_en" value="{{ old('name_en') }}"
                                    placeholder="Sovannou">
                                @error('name_en')
                                    <div class="field-error">{{ $message }}</div>
                                @enderror
                            </label>

                            <label class="field radio-field">
                                <span>ភិក្ខុ/សាមណេរ *</span>
                                <div class="radio-group">
                                    @foreach($monkTypes as $monkType)
                                        <label class="radio-pill">
                                            <input type="radio" name="monk_type_id" value="{{ $monkType->id }}"
                                                {{ old('monk_type_id') == $monkType->id ? 'checked' : '' }}>
                                            <span>{{ $monkType->name }}</span>
                                        </label>
                                    @endforeach
                                </div>
                                @error('monk_type_id')
                                    <div class="field-error">{{ $message }}</div>
                                @enderror
                            </label>

                            <label class="field">
                                <span>ថ្ងៃខែឆ្នាំកំណើត *</span>
                                @include('admin.components.khmer-date-picker-separate', [
                                    'name' => 'dob',
                                    'value' => old('dob'),
                                    'required' => true
                                ])
                                @error('dob')
                                    <div class="field-error">{{ $message }}</div>
                                @enderror
                            </label>
                        </div>
                    </div>

                    <div class="fieldset">
                        <div class="fieldset-title">
                            <h4>ទីកន្លែងកំណើត</h4>
                            <p>សូមបំពេញរាយនាមតាមលំដាប់រដ្ឋបាល</p>
                        </div>
                        <div class="field-grid">
                            <label class="field">
                                <span>ខេត្ត/ក្រុង *</span>
                                <select name="province_id" data-role="province" data-placeholder="ជ្រើសរើសខេត្ត" data-selected="{{ old('province_id') }}">
                                    <option value="">ជ្រើសរើសខេត្ត</option>
                                    @foreach($provinces as $province)
                                        <option value="{{ $province->id }}"
                                            {{ $provinceId == $province->id ? 'selected' : '' }}>
                                            {{ $province->name ?? $province->name_kh ?? $province->name_en }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('province_id')
                                    <div class="field-error">{{ $message }}</div>
                                @enderror
                            </label>
                            <label class="field">
                                <span>ស្រុក/ខណ្ឌ *</span>
                                <select name="district_id" data-role="district" data-selected="{{ old('district_id') }}"
                                    data-endpoint="{{ url('/api/provinces/:id/districts') }}"
                                    data-placeholder="ជ្រើសរើសស្រុក"
                                    data-disabled-placeholder="សូមជ្រើសខេត្តជាមុន"
                                    {{ $provinceId ? '' : 'disabled' }}>
                                    <option value="">
                                        {{ $provinceId ? 'ជ្រើសរើសស្រុក' : 'សូមជ្រើសខេត្តជាមុន' }}
                                    </option>
                                    @foreach($districts as $district)
                                        <option value="{{ $district->id }}"
                                            {{ $districtId == $district->id ? 'selected' : '' }}>
                                            {{ $district->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('district_id')
                                    <div class="field-error">{{ $message }}</div>
                                @enderror
                            </label>
                            <label class="field">
                                <span>ឃុំ/សង្កាត់ *</span>
                                <select name="commune_id" data-role="commune" data-selected="{{ old('commune_id') }}"
                                    data-endpoint="{{ url('/api/districts/:id/communes') }}"
                                    data-placeholder="ជ្រើសរើសឃុំ"
                                    data-disabled-placeholder="សូមជ្រើសស្រុកជាមុន"
                                    {{ $districtId ? '' : 'disabled' }}>
                                    <option value="">
                                        {{ $districtId ? 'ជ្រើសរើសឃុំ' : 'សូមជ្រើសស្រុកជាមុន' }}
                                    </option>
                                    @foreach($communes as $commune)
                                        <option value="{{ $commune->id }}"
                                            {{ $communeId == $commune->id ? 'selected' : '' }}>
                                            {{ $commune->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('commune_id')
                                    <div class="field-error">{{ $message }}</div>
                                @enderror
                            </label>
                            <label class="field">
                                <span>ភូមិ *</span>
                                <select name="village_id" data-role="village" data-selected="{{ old('village_id') }}"
                                    data-endpoint="{{ url('/api/communes/:id/villages') }}"
                                    data-placeholder="ជ្រើសរើសភូមិ"
                                    data-disabled-placeholder="សូមជ្រើសឃុំជាមុន"
                                    {{ $communeId ? '' : 'disabled' }}>
                                    <option value="">
                                        {{ $communeId ? 'ជ្រើសរើសភូមិ' : 'សូមជ្រើសឃុំជាមុន' }}
                                    </option>
                                    @foreach($villages as $village)
                                        <option value="{{ $village->id }}"
                                            {{ old('village_id') == $village->id ? 'selected' : '' }}>
                                            {{ $village->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('village_id')
                                    <div class="field-error">{{ $message }}</div>
                                @enderror
                            </label>
                        </div>
                    </div>

                    <div class="fieldset">
                        <div class="fieldset-title">
                            <h4>ព័ត៌មានការសិក្សា</h4>
                        </div>
                        <div class="field-grid">
                            <label class="field">
                                <span>កម្រិតវប្បធម៌ *</span>
                                <select name="education_id" data-role="education" data-placeholder="ជ្រើសរើសកម្រិតវប្បធម៌">
                                    <option value="">ជ្រើសរើស</option>
                                    @foreach($educations as $edu)
                                        <option value="{{ $edu->id }}"
                                            {{ old('education_id') == $edu->id ? 'selected' : '' }}>
                                            {{ $edu->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('education_id')
                                    <div class="field-error">{{ $message }}</div>
                                @enderror
                            </label>
                            <label class="field">
                                <span>ឆ្នាំសិក្សា</span>
                                <select name="education_year_id" data-role="education-year"
                                    data-endpoint="{{ url('/api/education/:id/years') }}"
                                    data-placeholder="ជ្រើសរើសឆ្នាំសិក្សា"
                                    data-disabled-placeholder="សូមជ្រើសកម្រិតវប្បធម៌មានមុន"
                                    {{ old('education_id') ? '' : 'disabled' }}>
                                    <option value="">
                                        {{ old('education_id') ? 'ជ្រើសរើសឆ្នាំសិក្សា' : 'សូមជ្រើសកម្រិតវប្បធម៌មានមុន' }}
                                    </option>
                                    @foreach($years as $year)
                                        <option value="{{ $year->id }}"
                                            {{ old('education_year_id') == $year->id ? 'selected' : '' }}>
                                            {{ $year->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </label>
                            <label class="field">
                                <span>កុដិ</span>
                                <select name="kudi_id">
                                    <option value="">ជ្រើសរើសកុដិ</option>
                                    @foreach($kudis as $kudi)
                                        <option value="{{ $kudi->id }}"
                                            {{ old('kudi_id') == $kudi->id ? 'selected' : '' }}>
                                            {{ $kudi->kudi_number }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('kudi_id')
                                    <div class="field-error">{{ $message }}</div>
                                @enderror
                            </label>
                           
                           
                        </div>
                    </div>

                    <div class="fieldset">
                        <div class="fieldset-title">
                            <h4>ព័ត៌មានមាតាបិតា</h4>
                            <p>បំពេញឈ្មោះ និងមុខរបរមាតាបិតាដោយដៃ</p>
                        </div>
                        <div class="field-grid">
                            <label class="field">
                                <span>ឈ្មោះឪពុក</span>
                                <input type="text" name="father_name" value="{{ old('father_name') }}"
                                    placeholder="ឧ. លោក សុវណ្ណ">
                            </label>
                            <label class="field">
                                <span>មុខរបរ ឪពុក</span>
                                <input type="text" name="father_job" value="{{ old('father_job') }}"
                                    placeholder="ឧ org កសិករ">
                            </label>
                            <label class="field">
                                <span>ឈ្មោះម្ដាយ</span>
                                <input type="text" name="mother_name" value="{{ old('mother_name') }}"
                                    placeholder="ឧ org លោកស្រី ផាន">
                            </label>
                            <label class="field">
                                <span>មុខរបរ ម្ដាយ</span>
                                <input type="text" name="mother_job" value="{{ old('mother_job') }}"
                                    placeholder="ឧ org ជាងដេរ">
                            </label>
                        </div>
                    </div>

                    <div class="fieldset">
                        <div class="fieldset-title">
                            <h4>អាសយដ្ឋានបច្ចុប្បន្ន</h4>
                            <p>ទីកន្លែងរស់នៅបច្ចុប្បន្ន និងវត្តដែលស្នាក់នៅ</p>
                        </div>
                        <div class="field-grid">
                            <label class="field">
                                <span>ឈ្មោះវត្ត (វត្តនាគវ័ន) *</span>
                                <input type="text" name="temple_name" value="{{ old('temple_name') }}"
                                    placeholder="ឧ. វត្តនាគវ័ន">
                            </label>
                            <label class="field">
                                <span>ខេត្ត/ក្រុង (បច្ចុប្បន្ន) *</span>
                                <select name="current_province_id" data-role="current-province" data-selected="{{ old('current_province_id') }}" data-placeholder="ជ្រើសរើសខេត្ត">
                                    <option value="">{{ __('ជ្រើសរើសខេត្ត') }}</option>
                                    @foreach($provinces as $province)
                                        <option value="{{ $province->id }}"
                                            {{ old('current_province_id') == $province->id ? 'selected' : '' }}>
                                            {{ $province->name ?? $province->name_kh ?? $province->name_en }}
                                        </option>
                                    @endforeach
                                </select>
                            </label>
                            <label class="field">
                                <span>ស្រុក/ខណ្ឌ (បច្ចុប្បន្ន) *</span>
                                <select name="current_district_id" data-role="current-district"
                                    data-selected="{{ old('current_district_id') }}"
                                    data-endpoint="{{ url('/api/provinces/:id/districts') }}"
                                    data-placeholder="ជ្រើសរើសស្រុក"
                                    data-disabled-placeholder="សូមជ្រើសខេត្តជាមុន"
                                    disabled>
                                    <option value="">សូមជ្រើសខេត្តជាមុន</option>
                                </select>
                            </label>
                            <label class="field">
                                <span>ឃុំ/សង្កាត់ (បច្ចុប្បន្ន) *</span>
                                <select name="current_commune_id" data-role="current-commune"
                                    data-selected="{{ old('current_commune_id') }}"
                                    data-endpoint="{{ url('/api/districts/:id/communes') }}"
                                    data-placeholder="ជ្រើសរើសឃុំ"
                                    data-disabled-placeholder="សូមជ្រើសស្រុកជាមុន"
                                    disabled>
                                    <option value="">សូមជ្រើសស្រុកជាមុន</option>
                                </select>
                            </label>
                            <label class="field">
                                <span>ភូមិ (បច្ចុប្បន្ន) *</span>
                                <select name="current_village_id" data-role="current-village"
                                    data-selected="{{ old('current_village_id') }}"
                                    data-endpoint="{{ url('/api/communes/:id/villages') }}"
                                    data-placeholder="ជ្រើសរើសភូមិ"
                                    data-disabled-placeholder="សូមជ្រើសឃុំជាមុន"
                                    disabled>
                                    <option value="">សូមជ្រើសឃុំជាមុន</option>
                                </select>
                            </label>
                        </div>
                    </div>

                    <div class="fieldset">
                        <div class="fieldset-title">
                            <h4>ទំនាក់ទំនងបន្ថែម</h4>
                        </div>
                         <label class="field field-full">
                                <span>លេខទូរស័ព្ទ *</span>
                                <input type="tel" name="phone_number"
                                    value="{{ old('phone_number') }}"
                                    placeholder="លេខទូរស័ព្ទ">
                            </label>
                        <div class="field-grid">
                            <label class="field field-full file-field">
                                <span>រូបថត *</span>
                                <input type="file" name="image" id="image-input" accept="image/*">
                                <div id="image-preview" style="margin-top: 10px; display: none;">
                                    <img id="preview-img" style="max-width: 200px; max-height: 200px; border-radius: 8px; border: 2px solid #e5e7eb;">
                                    <p style="margin-top: 5px; font-size: 0.9rem; color: #6b7280;">រូបភាពដែលបានជ្រើសរើស</p>
                                </div>
                                @if(old('image'))
                                    <div style="margin-top: 10px;">
                                        <img src="{{ asset('storage/' . old('image')) }}" style="max-width: 200px; max-height: 200px; border-radius: 8px; border: 2px solid #e5e7eb;">
                                        <p style="margin-top: 5px; font-size: 0.9rem; color: #6b7280;">រូបភាពដែលបានជ្រើសរើសពីមុន</p>
                                    </div>
                                @endif
                                @error('image')
                                    <div class="field-error">{{ $message }}</div>
                                @enderror
                            </label>
                           
                        </div>
                    </div>
                </article>

                <div class="form-footer">
                    <button class="btn btn-outline" type="reset">សម្អាតទិន្នន័យ</button>
                    <button class="btn btn-primary" type="submit">ចុះឈ្មោះ</button>
                </div>
            </form>
            
         
        </section>
    </div>

    @include('admin.components.location-select-script')
    
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script src="{{ asset('assets/js/form-validation.js') }}" defer></script>
    <script>
        // Clear any existing validation errors for education_year_id field
        document.addEventListener('DOMContentLoaded', function() {
            const educationYearField = document.querySelector('select[name="education_year_id"]');
            if (educationYearField) {
                const fieldContainer = educationYearField.closest('.field');
                if (fieldContainer) {
                    fieldContainer.classList.remove('field-error');
                    // Remove any existing error messages
                    const errorMessages = fieldContainer.querySelectorAll('.field-error');
                    errorMessages.forEach(error => error.remove());
                }
            }
        });
    </script>
    <script>
        // Khmer locale for flatpickr
        if (typeof flatpickr !== 'undefined') {
            flatpickr.l10ns.km = {
                weekdays: {
                    shorthand: ["អា", "ច", "អ", "ព", "ព្រ", "សុ", "ស"],
                    longhand: ["អាទិត្យ", "ចន្ទ", "អង្គារ", "ពុធ", "ព្រហស្បតិ៍", "សុក្រ", "សៅរ៍"]
                },
                months: {
                    shorthand: ["មករា", "កុម្ភៈ", "មីនា", "មេសា", "ឧសភា", "មិថុនា", "កក្កដា", "សីហា", "កញ្ញា", "តុលា", "វិច្ឆិកា", "ធ្នូ"],
                    longhand: ["មករា", "កុម្ភៈ", "មីនា", "មេសា", "ឧសភា", "មិថុនា", "កក្កដា", "សីហា", "កញ្ញា", "តុលា", "វិច្ឆិកា", "ធ្នូ"]
                },
                daysInMonth: ["31", "28", "31", "30", "31", "30", "31", "31", "30", "31", "30", "31"],
                firstDayOfWeek: 1,
                ordinal: function(nth) {
                    const ordinals = {
                        1: 'ទី១', 2: 'ទី២', 3: 'ទី៣', 4: 'ទី៤', 5: 'ទី៥',
                        6: 'ទី៦', 7: 'ទី៧', 8: 'ទី៨', 9: 'ទី៩', 10: 'ទី១០',
                        11: 'ទី១១', 12: 'ទី១២', 13: 'ទី១៣', 14: 'ទី១៤', 15: 'ទី១៥',
                        16: 'ទី១៦', 17: 'ទី១៧', 18: 'ទី១៨', 19: 'ទី១៩', 20: 'ទី២០',
                        21: 'ទី២១', 22: 'ទី២២', 23: 'ទី២៣', 24: 'ទី២៤', 25: 'ទី២៥',
                        26: 'ទី២៦', 27: 'ទី២៧', 28: 'ទី២៨', 29: 'ទី២៩', 30: 'ទី៣០',
                        31: 'ទី៣១'
                    };
                    return ordinals[nth] || 'ទី' + nth;
                },
                rangeSeparator: ' ដល់ ',
                weekAbbreviation: 'សប.',
                scrollTitle: 'រំកិល្លើដើម្បីជ្រើសឆ្នាំ',
                toggleTitle: 'បើកបិទជម្រើសកាលបរិត្យសម្រាត់',
                amPM: ['ព្រឹក', 'ល្ងាច'],
                yearAriaLabel: 'ឆ្នាំ',
                monthAriaLabel: 'ខែ',
                hourAriaLabel: 'មោោ',
                minuteAriaLabel: 'នាទី',
                secondAriaLabel: 'វិនាទី',
                time_24hr: true
            };
        }
        
       
        
        // Simple location dropdown functionality
        setTimeout(function() {
            console.log('Setting up location dropdowns...');
            
            // Function to load options
            function loadOptions(select, url, dependentValue, placeholder) {
                console.log('loadOptions called:', {url, dependentValue, placeholder});
                if (!dependentValue) {
                    select.innerHTML = `<option value="">${placeholder}</option>`;
                    select.disabled = true;
                    return;
                }
                
                const finalUrl = url.replace(':id', dependentValue);
                console.log('Fetching from:', finalUrl);
                
                fetch(finalUrl)
                    .then(response => {
                        console.log('Response status:', response.status);
                        if (!response.ok) {
                            throw new Error(`HTTP error! status: ${response.status}`);
                        }
                        return response.json();
                    })
                    .then(data => {
                        console.log('Data received:', data);
                        console.log('Data type:', typeof data);
                        console.log('Data length:', data.length);
                        
                        select.innerHTML = `<option value="">${placeholder}</option>`;
                        select.disabled = false;
                        
                        if (data.data && Array.isArray(data.data) && data.data.length > 0) {
                            data.data.forEach(item => {
                                const option = document.createElement('option');
                                option.value = item.id;
                                option.textContent = item.name;
                                select.appendChild(option);
                            });
                            console.log('Dropdown enabled and populated with', data.data.length, 'options');
                            
                            // Restore old value if exists
                            const selectedValue = select.getAttribute('data-selected');
                            if (selectedValue) {
                                console.log('Restoring selected value:', selectedValue);
                                select.value = selectedValue;
                            }
                        } else {
                            console.log('No data received or empty array');
                        }
                    })
                    .catch(error => {
                        console.error('Error fetching data:', error);
                        console.error('URL was:', finalUrl);
                    });
            }
            
            // Birth address
            const provinceSelect = document.querySelector('select[data-role="province"]');
            const districtSelect = document.querySelector('select[data-role="district"]');
            const communeSelect = document.querySelector('select[data-role="commune"]');
            const villageSelect = document.querySelector('select[data-role="village"]');
            
            // Enable dropdowns initially
            if (districtSelect) districtSelect.disabled = false;
            if (communeSelect) communeSelect.disabled = false;
            if (villageSelect) villageSelect.disabled = false;
            
            console.log('Birth address elements found:', {provinceSelect, districtSelect, communeSelect, villageSelect});
            
                        
            if (provinceSelect) {
                provinceSelect.addEventListener('change', function() {
                    console.log('Birth province changed:', this.value);
                    loadOptions(districtSelect, '/api/provinces/:id/districts', this.value, 'ជ្រើសរើសស្រុក');
                    communeSelect.innerHTML = '<option value="">សូមជ្រើសស្រុកជាមុន</option>';
                    communeSelect.disabled = true;
                    villageSelect.innerHTML = '<option value="">សូមជ្រើសឃុំជាមុន</option>';
                    villageSelect.disabled = true;
                });
            }
            
            if (districtSelect) {
                districtSelect.addEventListener('change', function() {
                    loadOptions(communeSelect, '/api/districts/:id/communes', this.value, 'ជ្រើសរើសឃុំ');
                    villageSelect.innerHTML = '<option value="">សូមជ្រើសឃុំជាមុន</option>';
                    villageSelect.disabled = true;
                });
            }
            
            if (communeSelect) {
                communeSelect.addEventListener('change', function() {
                    loadOptions(villageSelect, '/api/communes/:id/villages', this.value, 'ជ្រើសរើសភូមិ');
                });
            }
            
            // Current address
            const currentProvinceSelect = document.querySelector('select[data-role="current-province"]');
            const currentDistrictSelect = document.querySelector('select[data-role="current-district"]');
            const currentCommuneSelect = document.querySelector('select[data-role="current-commune"]');
            const currentVillageSelect = document.querySelector('select[data-role="current-village"]');
            
            // Enable current address dropdowns initially
            if (currentDistrictSelect) currentDistrictSelect.disabled = false;
            if (currentCommuneSelect) currentCommuneSelect.disabled = false;
            if (currentVillageSelect) currentVillageSelect.disabled = false;
            
            console.log('Current address elements found:', {currentProvinceSelect, currentDistrictSelect, currentCommuneSelect, currentVillageSelect});
            
                        
            if (currentProvinceSelect) {
                currentProvinceSelect.addEventListener('change', function() {
                    console.log('Current province changed:', this.value);
                    loadOptions(currentDistrictSelect, '/api/provinces/:id/districts', this.value, 'ជ្រើសរើសស្រុក');
                    currentCommuneSelect.innerHTML = '<option value="">សូមជ្រើសស្រុកជាមុន</option>';
                    currentCommuneSelect.disabled = true;
                    currentVillageSelect.innerHTML = '<option value="">សូមជ្រើសឃុំជាមុន</option>';
                    currentVillageSelect.disabled = true;
                });
            }
            
            if (currentDistrictSelect) {
                currentDistrictSelect.addEventListener('change', function() {
                    loadOptions(currentCommuneSelect, '/api/districts/:id/communes', this.value, 'ជ្រើសរើសឃុំ');
                    currentVillageSelect.innerHTML = '<option value="">សូមជ្រើសឃុំជាមុន</option>';
                    currentVillageSelect.disabled = true;
                });
            }
            
            if (currentCommuneSelect) {
                currentCommuneSelect.addEventListener('change', function() {
                    loadOptions(currentVillageSelect, '/api/communes/:id/villages', this.value, 'ជ្រើសរើសភូមិ');
                });
            }
            
            // Initialize old values on page load
            function initializeOldValues() {
                console.log('Initializing old values...');
                
                // Birth address old values
                const birthProvinceId = provinceSelect?.getAttribute('data-selected');
                const birthDistrictId = districtSelect?.getAttribute('data-selected');
                const birthCommuneId = communeSelect?.getAttribute('data-selected');
                const birthVillageId = villageSelect?.getAttribute('data-selected');
                
                // Current address old values
                const currentProvinceId = currentProvinceSelect?.getAttribute('data-selected');
                const currentDistrictId = currentDistrictSelect?.getAttribute('data-selected');
                const currentCommuneId = currentCommuneSelect?.getAttribute('data-selected');
                const currentVillageId = currentVillageSelect?.getAttribute('data-selected');
                
                // Initialize birth address
                if (birthProvinceId) {
                    console.log('Loading birth province:', birthProvinceId);
                    provinceSelect.value = birthProvinceId;
                    loadOptions(districtSelect, '/api/provinces/:id/districts', birthProvinceId, 'ជ្រើសរើសស្រុក');
                    
                    if (birthDistrictId) {
                        setTimeout(() => {
                            loadOptions(communeSelect, '/api/districts/:id/communes', birthDistrictId, 'ជ្រើសរើសឃុំ');
                            
                            if (birthCommuneId) {
                                setTimeout(() => {
                                    loadOptions(villageSelect, '/api/communes/:id/villages', birthCommuneId, 'ជ្រើសរើសភូមិ');
                                }, 500);
                            }
                        }, 500);
                    }
                }
                
                // Initialize current address
                if (currentProvinceId) {
                    console.log('Loading current province:', currentProvinceId);
                    currentProvinceSelect.value = currentProvinceId;
                    loadOptions(currentDistrictSelect, '/api/provinces/:id/districts', currentProvinceId, 'ជ្រើសរើសស្រុក');
                    
                    if (currentDistrictId) {
                        setTimeout(() => {
                            loadOptions(currentCommuneSelect, '/api/districts/:id/communes', currentDistrictId, 'ជ្រើសរើសឃុំ');
                            
                            if (currentCommuneId) {
                                setTimeout(() => {
                                    loadOptions(currentVillageSelect, '/api/communes/:id/villages', currentCommuneId, 'ជ្រើសរើសភូមិ');
                                }, 500);
                            }
                        }, 500);
                    }
                }
            }
            
            // Call initialization after a short delay to ensure all elements are loaded
            setTimeout(initializeOldValues, 100);
        }, 1000);
        
        // Image preview functionality
        document.addEventListener('DOMContentLoaded', function() {
            const imageInput = document.getElementById('image-input');
            const imagePreview = document.getElementById('image-preview');
            const previewImg = document.getElementById('preview-img');
            
            if (imageInput && imagePreview && previewImg) {
                imageInput.addEventListener('change', function(e) {
                    const file = e.target.files[0];
                    
                    if (file && file.type.startsWith('image/')) {
                        const reader = new FileReader();
                        
                        reader.onload = function(e) {
                            previewImg.src = e.target.result;
                            imagePreview.style.display = 'block';
                        };
                        
                        reader.readAsDataURL(file);
                    } else {
                        imagePreview.style.display = 'none';
                        previewImg.src = '';
                    }
                });
                
                // Clear preview when file is cleared
                imageInput.addEventListener('click', function() {
                    if (!this.files || this.files.length === 0) {
                        imagePreview.style.display = 'none';
                        previewImg.src = '';
                    }
                });
            }
        });
    </script>
</html>
