<!DOCTYPE html>
<html lang="km" dir="ltr" data-bs-theme="light">
<head>
    <meta charset="utf-8" />
    <title>កែប្រែព័ត៌មាន | {{ $userinfo->name_kh }}</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <link href="https://fonts.googleapis.com/css2?family=Kantumruy+Pro:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('assets/style/form.css') }}">
    <style>
        :root { --primary: #4c5cff; --muted: #6b7280; }
        body { margin: 0; min-height: 100vh; font-family: 'Kantumruy Pro', system-ui, sans-serif; background: linear-gradient(135deg, #f0f4ff, #faf5ff); }
        .page { padding: 1rem; max-width: 900px; margin: 0 auto; }
        .student-card { background: rgba(255,255,255,0.95); border-radius: 20px; padding: 1.5rem; box-shadow: 0 20px 50px rgba(27,39,92,0.1); }
        .card-header { display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 1rem; margin-bottom: 1.5rem; }
        .fieldset { margin-bottom: 1.5rem; }
        .field-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1rem; }
        .field { display: flex; flex-direction: column; }
        .field span { font-size: 0.85rem; color: var(--muted); margin-bottom: 0.35rem; }
        .field input, .field select { padding: 0.75rem 1rem; border: 1px solid rgba(0,0,0,0.1); border-radius: 12px; font-size: 1rem; }
        .radio-group { display: flex; flex-wrap: wrap; gap: 0.5rem; }
        .form-actions { display: flex; gap: 1rem; flex-wrap: wrap; }
        .form-actions button, .form-actions a { flex: 1; min-width: 150px; padding: 0.85rem 1.5rem; border-radius: 12px; font-size: 1rem; font-weight: 600; text-align: center; text-decoration: none; }
        .btn { border: none; border-radius: 12px; padding: 0.85rem 1.5rem; font-size: 1rem; font-weight: 600; cursor: pointer; transition: all 0.2s ease; }
        .btn-outline { background: transparent; border: 2px solid #6b7280; color: #6b7280; }
        .btn-outline:hover { background: #6b7280; color: white; }
        .btn-primary { background: #4c5cff; color: white; }
        .btn-primary:hover { background: #3644ff; transform: translateY(-1px); }
        .form-footer { display: flex; gap: 1rem; flex-wrap: wrap; margin-top: 1.5rem; }
        @media (max-width: 768px) {
            .student-card { padding: 1rem; border-radius: 16px; }
            .card-header { flex-direction: column; align-items: flex-start; }
            .field-grid { grid-template-columns: 1fr; }
        }
        @media (max-width: 480px) {
            .page { padding: 0.75rem; }
            .student-card { padding: 0.75rem; border-radius: 12px; }
            .field input, .field select { padding: 0.65rem 0.85rem; font-size: 0.9rem; }
            .form-actions { flex-direction: column; }
            .form-actions button, .form-actions a { width: 100%; }
        }
    </style>
</head>
<body>
    <div class="page">
        <div style="text-align:center;padding:2rem 1rem;">
            <h1 style="font-size:1.75rem;margin:0 0 0.5rem;">កែប្រែព័ត៌មានរបស់អ្នក</h1>
            <p style="color:#6b7280;margin:0;">{{ $userinfo->name_kh }} - {{ $userinfo->id_number }}</p>
        </div>
        <section class="form-section" id="register">
            @php
                $selectedProvince = old('province_id', $userinfo->province_id ?? null);
                $selectedDistrict = old('district_id', $userinfo->district_id ?? null);
                $selectedCommune = old('commune_id', $userinfo->commune_id ?? null);
                $selectedCurrentProvince = old('current_province_id', $userinfo->current_province_id ?? null);
                $selectedCurrentDistrict = old('current_district_id', $userinfo->current_district_id ?? null);
                $selectedCurrentCommune = old('current_commune_id', $userinfo->current_commune_id ?? null);
            @endphp
            @if(session('success'))
                <div style="background: rgba(34, 197, 94, 0.15); color: #166534; border: 1px solid rgba(34, 197, 94, 0.3); border-radius: 12px; padding: 1rem; margin-bottom: 1rem;">
                    {{ session('success') }}
                </div>
            @endif

            @if($errors->any())
                <div style="background: rgba(239, 68, 68, 0.15); color: #991b1b; border: 1px solid rgba(239, 68, 68, 0.3); border-radius: 12px; padding: 1rem; margin-bottom: 1rem;">
                    <ul style="margin: 0; padding-left: 1.5rem;">
                        @foreach($errors->all() as $error)
                            <li style="margin-bottom: 0.25rem;">{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form class="register-form" data-location-form action="{{ URL::signedRoute('profile.edit', ['id' => $userinfo->id]) }}" method="post" enctype="multipart/form-data">
                @csrf
                    <article class="student-card">
                        <div class="card-header"><div><h3>កែប្រែព័ត៌មាន</h3></div><span class="status-pill">កែប្រែ</span></div>
                        <div class="fieldset">
                            <div class="fieldset-title"><h4>ព័ត៌មានផ្ទាល់ខ្លួន</h4></div>
                            <div class="field-grid">
                                <label class="field"><span>អត្តលេខ *</span><input type="text" name="id_number" value="{{ old('id_number', $userinfo->id_number) }}" required></label>
                                <label class="field"><span>ឈ្មោះ (ខ្មែរ) *</span><input type="text" name="name_kh" value="{{ old('name_kh', $userinfo->name_kh) }}" required></label>
                                <label class="field"><span>ឈ្មោះ (ឡាតាំង) *</span><input type="text" name="name_en" value="{{ old('name_en', $userinfo->name_en) }}" required></label>
                                <label class="field radio-field"><span>ភិក្ខុ/សាមណេរ</span>
                                    <div class="radio-group">
                                        @foreach($monkTypes as $monkType)
                                            <label class="radio-pill"><input type="radio" name="monk_type_id" value="{{ $monkType->id }}" {{ old('monk_type_id', $userinfo->monk_type_id) == $monkType->id ? 'checked' : '' }}><span>{{ $monkType->name }}</span></label>
                                        @endforeach
                                    </div>
                                </label>
                                <label class="field"><span>ថ្ងៃខែឆ្នាំកំណើត</span><input type="date" name="dob" value="{{ old('dob', $userinfo->dob ? \Carbon\Carbon::parse($userinfo->dob)->format('Y-m-d') : '') }}"></label>
                            </div>
                        </div>
                        <div class="fieldset">
                            <div class="fieldset-title"><h4>ទីកន្លែងកំណើត</h4></div>
                            <div class="field-grid">
                                <label class="field"><span>ខេត្ត/ក្រុង</span>
                                    <select name="province_id" data-role="province" data-placeholder="ជ្រើសរើសខេត្ត">
                                        <option value="">ជ្រើសរើសខេត្ត</option>
                                        @foreach($provinces as $province)<option value="{{ $province->id }}" {{ $selectedProvince == $province->id ? 'selected' : '' }}>{{ $province->name }}</option>@endforeach
                                    </select>
                                </label>
                                <label class="field"><span>ស្រុក/ខណ្ឌ</span>
                                    <select name="district_id" data-role="district" data-endpoint="{{ url('/api/provinces/:id/districts') }}" data-placeholder="ជ្រើសរើសស្រុក" {{ $selectedProvince ? '' : 'disabled' }}>
                                        <option value="">{{ $selectedProvince ? 'ជ្រើសរើសស្រុក' : 'សូមជ្រើសខេត្តជាមុន' }}</option>
                                        @foreach($districts as $district)<option value="{{ $district->id }}" {{ $selectedDistrict == $district->id ? 'selected' : '' }}>{{ $district->name }}</option>@endforeach
                                    </select>
                                </label>
                                <label class="field"><span>ឃុំ/សង្កាត់</span>
                                    <select name="commune_id" data-role="commune" data-endpoint="{{ url('/api/districts/:id/communes') }}" data-placeholder="ជ្រើសរើសឃុំ" {{ $selectedDistrict ? '' : 'disabled' }}>
                                        <option value="">{{ $selectedDistrict ? 'ជ្រើសរើសឃុំ' : 'សូមជ្រើសស្រុកជាមុន' }}</option>
                                        @foreach($communes as $commune)<option value="{{ $commune->id }}" {{ $selectedCommune == $commune->id ? 'selected' : '' }}>{{ $commune->name }}</option>@endforeach
                                    </select>
                                </label>
                                <label class="field"><span>ភូមិ</span>
                                    <select name="village_id" data-role="village" data-endpoint="{{ url('/api/communes/:id/villages') }}" data-placeholder="ជ្រើសរើសភូមិ" {{ $selectedCommune ? '' : 'disabled' }}>
                                        <option value="">{{ $selectedCommune ? 'ជ្រើសរើសភូមិ' : 'សូមជ្រើសឃុំជាមុន' }}</option>
                                        @foreach($villages as $village)<option value="{{ $village->id }}" {{ old('village_id', $userinfo->village_id) == $village->id ? 'selected' : '' }}>{{ $village->name }}</option>@endforeach
                                    </select>
                                </label>
                            </div>
                        </div>
                        <div class="fieldset">
                            <div class="fieldset-title"><h4>ព័ត៌មានការសិក្សា</h4></div>
                            <div class="field-grid">
                                <label class="field"><span>កម្រិតវប្បធម៌</span>
                                    <select name="education_id" data-role="education" data-placeholder="ជ្រើសរើសកម្រិតវប្បធម៌">
                                        <option value="">ជ្រើសរើស</option>
                                        @foreach($educations as $edu)<option value="{{ $edu->id }}" {{ old('education_id', $userinfo->education_id) == $edu->id ? 'selected' : '' }}>{{ $edu->name }}</option>@endforeach
                                    </select>
                                </label>
                                <label class="field"><span>ឆ្នាំសិក្សា</span>
                                    <select name="education_year_id" data-role="education-year" data-endpoint="{{ url('/api/education/:id/years') }}" data-placeholder="ជ្រើសរើសឆ្នាំសិក្សា" {{ old('education_id', $userinfo->education_id) ? '' : 'disabled' }}>
                                        <option value="">{{ old('education_id', $userinfo->education_id) ? 'ជ្រើសរើសឆ្នាំសិក្សា' : 'សូមជ្រើសកម្រិតវប្បធម៌មានមុន' }}</option>
                                        @foreach($years as $year)<option value="{{ $year->id }}" {{ old('education_year_id', $userinfo->education_year_id) == $year->id ? 'selected' : '' }}>{{ $year->name }}</option>@endforeach
                                    </select>
                                </label>
                                <label class="field"><span>កុដិ</span>
                                    <select name="kudi_id">
                                        <option value="">ជ្រើសរើសកុដិ</option>
                                        @foreach($kudis as $kudi)<option value="{{ $kudi->id }}" {{ old('kudi_id', $userinfo->kudi_id) == $kudi->id ? 'selected' : '' }}>{{ $kudi->kudi_number }}</option>@endforeach
                                    </select>
                                </label>
                            </div>
                        </div>
                        <div class="fieldset">
                            <div class="fieldset-title"><h4>អាសយដ្ឋានបច្ចុប្បន្ន</h4><p>ទីកន្លែងរស់នៅបច្ចុប្បន្ន និងវត្តដែលស្នាក់នៅ</p></div>
                            <div class="field-grid">
                                <label class="field"><span>ឈ្មោះវត្ត</span><input type="text" name="temple_name" value="{{ old('temple_name', $userinfo->temple_name) }}" placeholder="ឧ. វត្តនាគវ័ន"></label>
                                <label class="field"><span>ខេត្ត/ក្រុង (បច្ចុប្បន្ន)</span>
                                    <select name="current_province_id" data-role="current-province" data-placeholder="ជ្រើសរើសខេត្ត">
                                        <option value="">ជ្រើសរើសខេត្ត</option>
                                        @foreach($provinces as $province)<option value="{{ $province->id }}" {{ old('current_province_id', $userinfo->current_province_id) == $province->id ? 'selected' : '' }}>{{ $province->name }}</option>@endforeach
                                    </select>
                                </label>
                                <label class="field"><span>ស្រុក/ខណ្ឌ (បច្ចុប្បន្ន)</span>
                                    <select name="current_district_id" data-role="current-district" data-endpoint="{{ url('/api/provinces/:id/districts') }}" data-placeholder="ជ្រើសរើសស្រុក" {{ $selectedCurrentProvince ? '' : 'disabled' }}>
                                        <option value="">{{ $selectedCurrentProvince ? 'ជ្រើសរើសស្រុក' : 'សូមជ្រើសខេត្តជាមុន' }}</option>
                                        @foreach($currentDistricts as $district)<option value="{{ $district->id }}" {{ $selectedCurrentDistrict == $district->id ? 'selected' : '' }}>{{ $district->name }}</option>@endforeach
                                    </select>
                                </label>
                                <label class="field"><span>ឃុំ/សង្កាត់ (បច្ចុប្បន្ន)</span>
                                    <select name="current_commune_id" data-role="current-commune" data-endpoint="{{ url('/api/districts/:id/communes') }}" data-placeholder="ជ្រើសរើសឃុំ" {{ $selectedCurrentDistrict ? '' : 'disabled' }}>
                                        <option value="">{{ $selectedCurrentDistrict ? 'ជ្រើសរើសឃុំ' : 'សូមជ្រើសស្រុកជាមុន' }}</option>
                                        @foreach($currentCommunes as $commune)<option value="{{ $commune->id }}" {{ $selectedCurrentCommune == $commune->id ? 'selected' : '' }}>{{ $commune->name }}</option>@endforeach
                                    </select>
                                </label>
                                <label class="field"><span>ភូមិ (បច្ចុប្បន្ន)</span>
                                    <select name="current_village_id" data-role="current-village" data-endpoint="{{ url('/api/communes/:id/villages') }}" data-placeholder="ជ្រើសរើសភូមិ" {{ $selectedCurrentCommune ? '' : 'disabled' }}>
                                        <option value="">{{ $selectedCurrentCommune ? 'ជ្រើសរើសភូមិ' : 'សូមជ្រើសឃុំជាមុន' }}</option>
                                        @foreach($currentVillages as $village)<option value="{{ $village->id }}" {{ old('current_village_id', $userinfo->current_village_id) == $village->id ? 'selected' : '' }}>{{ $village->name }}</option>@endforeach
                                    </select>
                                </label>
                            </div>
                        </div>
                        <div class="fieldset">
                            <div class="fieldset-title"><h4>ព័ត៌មានមាតាបិតា</h4></div>
                            <div class="field-grid">
                                <label class="field"><span>ឈ្មោះឪពុក</span><input type="text" name="father_name" value="{{ old('father_name', $userinfo->father_name) }}"></label>
                                <label class="field"><span>មុខរបរ ឪពុក</span><input type="text" name="father_job" value="{{ old('father_job', $userinfo->father_job) }}"></label>
                                <label class="field"><span>ឈ្មោះម្ដាយ</span><input type="text" name="mother_name" value="{{ old('mother_name', $userinfo->mother_name) }}"></label>
                                <label class="field"><span>មុខរបរ ម្ដាយ</span><input type="text" name="mother_job" value="{{ old('mother_job', $userinfo->mother_job) }}"></label>
                            </div>
                        </div>
                        <div class="fieldset">
                            <div class="fieldset-title"><h4>ទំនាក់ទំនង</h4></div>
                            <div class="field-grid">
                                <label class="field field-full"><span>លេខទូរស័ព្ទ</span><input type="tel" name="phone_number" value="{{ old('phone_number', $userinfo->phone_number) }}"></label>
                                <div class="field field-full file-field">
                                    <span>រូបថត</span>
                                    @if($userinfo->image)
                                        <div style="margin-bottom: 0.75rem;">
                                            <img src="{{ asset('storage/' . $userinfo->image) }}" alt="{{ $userinfo->name_kh }}" style="width: 100px; height: 100px; object-fit: cover; border-radius: 12px; border: 2px solid #e5e7eb;">
                                            <p style="margin-top: 5px; font-size: 0.8rem; color: #6b7280;">រូបថតបច្ចុប្បន្ន</p>
                                        </div>
                                    @endif
                                    <input type="file" name="image" id="image-input" accept="image/*">
                                    <div id="image-preview" style="margin-top: 10px; display: none;">
                                        <img id="preview-img" style="max-width: 200px; max-height: 200px; border-radius: 8px; border: 2px solid #e5e7eb;">
                                        <p style="margin-top: 5px; font-size: 0.9rem; color: #6b7280;">រូបភាពដែលបានជ្រើសរើស</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </article>
                    <div class="form-footer">
                        <a href="{{ URL::signedRoute('profile.public', ['id' => $userinfo->id]) }}" class="btn btn-outline">បោះបង់</a>
                        <button class="btn btn-primary" type="submit">រក្សាទុកការកែប្រែ</button>
                    </div>
                </form>
        </section>
    </div>
    @include('admin.components.location-select-script')
    <script src="{{ asset('assets/js/form-validation.js') }}" defer></script>
    <script>
        // Image preview functionality for edit form
        document.addEventListener('DOMContentLoaded', function() {
            const imageInput = document.getElementById('image-input');
            const imagePreview = document.getElementById('image-preview');
            const previewImg = document.getElementById('preview-img');
            
            if (imageInput && imagePreview && previewImg) {
                // Show current image initially
                @if($userinfo->image)
                    const currentImage = '{{ asset('storage/' . $userinfo->image) }}';
                    previewImg.src = currentImage;
                    imagePreview.style.display = 'block';
                @endif
                
                imageInput.addEventListener('change', function(e) {
                    const file = e.target.files[0];
                    
                    if (file && file.type.startsWith('image/')) {
                        const reader = new FileReader();
                        
                        reader.onload = function(e) {
                            previewImg.src = e.target.result;
                            imagePreview.style.display = 'block';
                        };
                        
                        reader.readAsDataURL(file);
                    } else {
                        // If no file selected, show current image again
                        @if($userinfo->image)
                            const currentImage = '{{ asset('storage/' . $userinfo->image) }}';
                            previewImg.src = currentImage;
                            imagePreview.style.display = 'block';
                        @else
                            imagePreview.style.display = 'none';
                            previewImg.src = '';
                        @endif
                    }
                });
            }
        });
    </script>
</body>
</html>
