<!DOCTYPE html>
<html lang="km">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Profile Information</title>
    <style>
        @page {
            margin: 15mm;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 9px;
            line-height: 1.4;
            color: #1f2937;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
        }
        
        .header {
            text-align: center;
            margin-bottom: 10px;
            padding-bottom: 8px;
            border-bottom: 2px solid #4c5cff;
        }
        
        .header h1 {
            font-size: 16px;
            color: #4c5cff;
            margin-bottom: 3px;
        }
        
        .header p {
            font-size: 9px;
            color: #6b7280;
        }
        
        .profile-photo {
            text-align: center;
            margin-bottom: 10px;
        }
        
        .profile-photo img {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            border: 3px solid #4c5cff;
        }
        
        .section {
            margin-bottom: 10px;
            page-break-inside: avoid;
        }
        
        .section-title {
            background: #f3f4f6;
            padding: 5px 8px;
            margin-bottom: 5px;
            border-left: 3px solid #4c5cff;
        }
        
        .section-title h2 {
            font-size: 11px;
            color: #1f2937;
            margin: 0;
        }
        
        .field-grid {
            display: table;
            width: 100%;
            border-collapse: collapse;
        }
        
        .field-row {
            display: table-row;
        }
        
        .field {
            display: table-cell;
            padding: 4px 6px;
            width: 33.33%;
            vertical-align: top;
        }
        
        .field-label {
            font-size: 8px;
            color: #6b7280;
            font-weight: 600;
            display: block;
            margin-bottom: 2px;
        }
        
        .field-value {
            font-size: 9px;
            color: #1f2937;
            background: #f9fafb;
            padding: 4px 6px;
            border-radius: 4px;
            border: 1px solid #e5e7eb;
            display: block;
        }
        
        .footer {
            margin-top: 15px;
            padding-top: 8px;
            border-top: 1px solid #e5e7eb;
            text-align: center;
            font-size: 8px;
            color: #9ca3af;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Member Profile Information</h1>
            <p>{{ $userinfo->name_en ?? $userinfo->name_kh }} - ID: {{ $userinfo->id_number }}</p>
        </div>

        @if($userinfo->image)
        <div class="profile-photo">
            <img src="{{ public_path('storage/' . $userinfo->image) }}" alt="{{ $userinfo->name_kh }}">
        </div>
        @endif

        <div class="section">
            <div class="section-title">
                <h2>Personal Information</h2>
            </div>
            <div class="field-grid">
                <div class="field-row">
                    <div class="field">
                        <span class="field-label">ID Number</span>
                        <span class="field-value">{{ $userinfo->id_number ?? '-' }}</span>
                    </div>
                    <div class="field">
                        <span class="field-label">Name (Khmer)</span>
                        <span class="field-value">{{ $userinfo->name_kh ?? '-' }}</span>
                    </div>
                    <div class="field">
                        <span class="field-label">Name (Latin)</span>
                        <span class="field-value">{{ $userinfo->name_en ?? '-' }}</span>
                    </div>
                </div>
                <div class="field-row">
                    <div class="field">
                        <span class="field-label">Member Type</span>
                        <span class="field-value">{{ optional($userinfo->monkType)->name ?? '-' }}</span>
                    </div>
                    <div class="field">
                        <span class="field-label">Date of Birth</span>
                        <span class="field-value">{{ $userinfo->dob ? \Carbon\Carbon::parse($userinfo->dob)->format('d/m/Y') : '-' }}</span>
                    </div>
                    <div class="field">
                        <span class="field-label">Phone Number</span>
                        <span class="field-value">{{ $userinfo->phone_number ?? '-' }}</span>
                    </div>
                </div>
                @if($userinfo->kudi)
                <div class="field-row">
                    <div class="field">
                        <span class="field-label">Kudi</span>
                        <span class="field-value">{{ $userinfo->kudi->kudi_number }}</span>
                    </div>
                    <div class="field"></div>
                    <div class="field"></div>
                </div>
                @endif
            </div>
        </div>

        <div class="section">
            <div class="section-title">
                <h2>Place of Birth</h2>
            </div>
            <div class="field-grid">
                <div class="field-row">
                    <div class="field">
                        <span class="field-label">ខេត្ត/ក្រុង</span>
                        <span class="field-value">{{ optional($userinfo->province)->name ?? '-' }}</span>
                    </div>
                    <div class="field">
                        <span class="field-label">ស្រុក/ខណ្ឌ</span>
                        <span class="field-value">{{ optional($userinfo->district)->name ?? '-' }}</span>
                    </div>
                    <div class="field">
                        <span class="field-label">ឃុំ/សង្កាត់</span>
                        <span class="field-value">{{ optional($userinfo->commune)->name ?? '-' }}</span>
                    </div>
                </div>
                <div class="field-row">
                    <div class="field">
                        <span class="field-label">ភូមិ</span>
                        <span class="field-value">{{ optional($userinfo->village)->name ?? '-' }}</span>
                    </div>
                    <div class="field"></div>
                    <div class="field"></div>
                </div>
            </div>
        </div>

        <div class="section">
            <div class="section-title">
                <h2>Current Address</h2>
            </div>
            <div class="field-grid">
                <div class="field-row">
                    <div class="field">
                        <span class="field-label">Temple Name</span>
                        <span class="field-value">{{ $userinfo->temple_name ?? '-' }}</span>
                    </div>
                    <div class="field">
                        <span class="field-label">ខេត្ត/ក្រុង</span>
                        <span class="field-value">{{ optional($userinfo->currentProvince)->name ?? '-' }}</span>
                    </div>
                    <div class="field">
                        <span class="field-label">ស្រុក/ខណ្ឌ</span>
                        <span class="field-value">{{ optional($userinfo->currentDistrict)->name ?? '-' }}</span>
                    </div>
                </div>
                <div class="field-row">
                    <div class="field">
                        <span class="field-label">ឃុំ/សង្កាត់</span>
                        <span class="field-value">{{ optional($userinfo->currentCommune)->name ?? '-' }}</span>
                    </div>
                    <div class="field">
                        <span class="field-label">ភូមិ</span>
                        <span class="field-value">{{ optional($userinfo->currentVillage)->name ?? '-' }}</span>
                    </div>
                    <div class="field"></div>
                </div>
            </div>
        </div>

        <div class="section">
            <div class="section-title">
                <h2>Parents Information</h2>
            </div>
            <div class="field-grid">
                <div class="field-row">
                    <div class="field">
                        <span class="field-label">Father's Name</span>
                        <span class="field-value">{{ $userinfo->father_name ?? '-' }}</span>
                    </div>
                    <div class="field">
                        <span class="field-label">Father's Job</span>
                        <span class="field-value">{{ $userinfo->father_job ?? '-' }}</span>
                    </div>
                    <div class="field">
                        <span class="field-label">Mother's Name</span>
                        <span class="field-value">{{ $userinfo->mother_name ?? '-' }}</span>
                    </div>
                </div>
                <div class="field-row">
                    <div class="field">
                        <span class="field-label">Mother's Job</span>
                        <span class="field-value">{{ $userinfo->mother_job ?? '-' }}</span>
                    </div>
                    <div class="field"></div>
                    <div class="field"></div>
                </div>
            </div>
        </div>

        <div class="section">
            <div class="section-title">
                <h2>Education Information</h2>
            </div>
            <div class="field-grid">
                <div class="field-row">
                    <div class="field">
                        <span class="field-label">Education Level</span>
                        <span class="field-value">{{ optional($userinfo->education)->name ?? '-' }}</span>
                    </div>
                    <div class="field">
                        <span class="field-label">Education Year</span>
                        <span class="field-value">{{ optional($userinfo->educationYear)->name ?? '-' }}</span>
                    </div>
                    <div class="field"></div>
                </div>
            </div>
        </div>

        <div class="footer">
            <p>Generated on {{ date('d/m/Y') }} | Monk Management System</p>
        </div>
    </div>
</body>
</html>
