<!DOCTYPE html>
<html lang="km">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ទាញយកព័ត៌មាន | {{ $userinfo->name_kh }}</title>
    <link href="https://fonts.googleapis.com/css2?family=Kantumruy+Pro:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Kantumruy Pro', sans-serif; background: #fff; color: #1a1f36; padding: 2rem; }
        .container { max-width: 800px; margin: 0 auto; }
        .header { text-align: center; margin-bottom: 2rem; border-bottom: 2px solid #4c5cff; padding-bottom: 1rem; }
        .header h1 { font-size: 1.5rem; color: #4c5cff; margin-bottom: 0.5rem; }
        .header p { color: #6b7280; }
        .profile-photo { text-align: center; margin-bottom: 1.5rem; }
        .profile-photo img { width: 120px; height: 120px; border-radius: 12px; object-fit: cover; border: 2px solid #4c5cff; }
        .profile-name { text-align: center; margin-bottom: 2rem; }
        .profile-name h2 { font-size: 1.75rem; margin-bottom: 0.25rem; }
        .profile-name p { color: #6b7280; }
        .section { margin-bottom: 1.5rem; }
        .section-title { background: #f3f4f6; padding: 0.5rem 1rem; font-weight: 600; margin-bottom: 0.75rem; border-left: 4px solid #4c5cff; }
        .field-grid { display: grid; grid-template-columns: repeat(2, 1fr); gap: 0.75rem 2rem; padding: 0 1rem; }
        .field label { display: block; font-size: 0.75rem; color: #6b7280; text-transform: uppercase; margin-bottom: 0.25rem; }
        .field p { font-weight: 500; }
        .print-btn { display: block; width: 200px; margin: 2rem auto; padding: 0.75rem 1.5rem; background: #4c5cff; color: #fff; border: none; border-radius: 8px; font-size: 1rem; cursor: pointer; text-align: center; }
        .print-btn:hover { background: #3644ff; }

        /* Responsive Styles */
        @media (max-width: 768px) {
            body { padding: 1rem; }
            .header h1 { font-size: 1.25rem; }
            .profile-photo img { width: 100px; height: 100px; }
            .profile-name h2 { font-size: 1.5rem; }
            .field-grid { grid-template-columns: 1fr 1fr; gap: 0.5rem 1rem; }
        }

        @media (max-width: 480px) {
            body { padding: 0.75rem; }
            .header { margin-bottom: 1.5rem; padding-bottom: 0.75rem; }
            .header h1 { font-size: 1.1rem; }
            .profile-photo img { width: 80px; height: 80px; }
            .profile-name h2 { font-size: 1.25rem; }
            .profile-name { margin-bottom: 1.5rem; }
            .section { margin-bottom: 1rem; }
            .section-title { font-size: 0.9rem; padding: 0.4rem 0.75rem; }
            .field-grid { grid-template-columns: 1fr; gap: 0.5rem; padding: 0 0.5rem; }
            .field label { font-size: 0.7rem; }
            .field p { font-size: 0.9rem; }
            .print-btn { width: 100%; margin: 1.5rem auto; }
        }

        @media print {
            .print-btn { display: none !important; }
            body { padding: 0; }
            .section-title { background: #f3f4f6 !important; -webkit-print-color-adjust: exact; print-color-adjust: exact; }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>វត្តនាគវន្ន</h1>
            <p>ព័ត៌មានលម្អិតសមាជិក</p>
        </div>

        <div class="profile-photo">
            @if($userinfo->image)
                <img src="{{ asset('storage/' . $userinfo->image) }}" alt="{{ $userinfo->name_kh }}">
            @else
                <img src="https://ui-avatars.com/api/?name={{ urlencode($userinfo->name_kh) }}&background=4c5cff&color=fff&size=120" alt="{{ $userinfo->name_kh }}">
            @endif
        </div>

        <div class="profile-name">
            <h2>{{ $userinfo->name_kh }}</h2>
            <p>{{ $userinfo->name_en }}</p>
        </div>

        <div class="section">
            <div class="section-title">ព័ត៌មានផ្ទាល់ខ្លួន</div>
            <div class="field-grid">
                <div class="field"><label>អត្តលេខ</label><p>{{ $userinfo->id_number ?? '-' }}</p></div>
                <div class="field"><label>លេខទូរស័ព្ទ</label><p>{{ $userinfo->phone_number ?? '-' }}</p></div>
                <div class="field"><label>ថ្ងៃខែឆ្នាំកំណើត</label><p>{{ $userinfo->dob ? \Carbon\Carbon::parse($userinfo->dob)->format('d/m/Y') : '-' }}</p></div>
                <div class="field"><label>ប្រភេទសមាជិក</label><p>{{ optional($userinfo->monkType)->name ?? '-' }}</p></div>
            </div>
        </div>

        <div class="section">
            <div class="section-title">ទីកន្លែងកំណើត</div>
            <div class="field-grid">
                <div class="field"><label>ខេត្ត/ក្រុង</label><p>{{ optional($userinfo->province)->name ?? '-' }}</p></div>
                <div class="field"><label>ស្រុក/ខណ្ឌ</label><p>{{ optional($userinfo->district)->name ?? '-' }}</p></div>
                <div class="field"><label>ឃុំ/សង្កាត់</label><p>{{ optional($userinfo->commune)->name ?? '-' }}</p></div>
                <div class="field"><label>ភូមិ</label><p>{{ optional($userinfo->village)->name ?? '-' }}</p></div>
            </div>
        </div>

        <div class="section">
            <div class="section-title">ព័ត៌មានមាតាបិតា</div>
            <div class="field-grid">
                <div class="field"><label>ឈ្មោះឪពុក</label><p>{{ $userinfo->father_name ?? '-' }}</p></div>
                <div class="field"><label>មុខរបរ ឪពុក</label><p>{{ $userinfo->father_job ?? '-' }}</p></div>
                <div class="field"><label>ឈ្មោះម្តាយ</label><p>{{ $userinfo->mother_name ?? '-' }}</p></div>
                <div class="field"><label>មុខរបរ ម្តាយ</label><p>{{ $userinfo->mother_job ?? '-' }}</p></div>
            </div>
        </div>

        <div class="section">
            <div class="section-title">អាសយដ្ឋានបច្ចុប្បន្ន</div>
            <div class="field-grid">
                <div class="field"><label>វត្ត</label><p>{{ $userinfo->temple_name ?? '-' }}</p></div>
                <div class="field"><label>ខេត្ត/ក្រុង</label><p>{{ optional($userinfo->currentProvince)->name ?? '-' }}</p></div>
                <div class="field"><label>ស្រុក/ខណ្ឌ</label><p>{{ optional($userinfo->currentDistrict)->name ?? '-' }}</p></div>
                <div class="field"><label>ឃុំ/សង្កាត់</label><p>{{ optional($userinfo->currentCommune)->name ?? '-' }}</p></div>
                <div class="field"><label>ភូមិ</label><p>{{ optional($userinfo->currentVillage)->name ?? '-' }}</p></div>
            </div>
        </div>

        <div class="section">
            <div class="section-title">ព័ត៌មានការសិក្សា</div>
            <div class="field-grid">
                <div class="field"><label>កម្រិតវប្បធម៌</label><p>{{ optional($userinfo->education)->name ?? '-' }}</p></div>
                <div class="field"><label>ឆ្នាំសិក្សា</label><p>{{ optional($userinfo->educationYear)->name ?? '-' }}</p></div>
                <div class="field"><label>កុដិ</label><p>{{ optional($userinfo->kudi)->kudi_number ?? '-' }}</p></div>
            </div>
        </div>

        <button class="print-btn" onclick="window.print()">🖨️ បោះពុម្ព / ទាញយក PDF</button>
    </div>
</body>
</html>
