<!DOCTYPE html>
<html lang="km">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ទាញយកព័ត៌មាន | {{ $userinfo->name_kh }}</title>
    <link href="https://fonts.googleapis.com/css2?family=Kantumruy+Pro:wght@400;500;600;700&family=Space+Grotesk:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('assets/style/profile-form-style.css') }}">
    <style>
        @page {
            size: A4;
            margin: 10mm;
        }
        
        @media print {
            * {
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
            }
            
            .no-print { display: none !important; }
            
            html, body { 
                background: white !important;
                margin: 0 !important;
                padding: 0 !important;
                height: auto !important;
            }
            
            .page { 
                padding: 0 !important;
                margin: 0 !important;
                max-width: 100% !important;
                width: 100% !important;
            }
            
            .student-card { 
                box-shadow: none !important; 
                border: 1px solid #ddd !important;
                padding: 10px !important;
                margin: 0 !important;
                page-break-inside: avoid;
            }
            
            .card-header {
                margin-bottom: 6px !important;
                padding-bottom: 4px !important;
                border-bottom: 1px solid #e5e7eb !important;
            }
            
            .card-header h3 {
                font-size: 1.1rem !important;
                margin: 0 !important;
                line-height: 1.2 !important;
            }
            
            .profile-photo-section {
                margin-bottom: 8px !important;
                text-align: center !important;
            }
            
            .profile-photo {
                width: 80px !important;
                height: 80px !important;
            }
            
            .fieldset {
                margin-bottom: 8px !important;
                page-break-inside: avoid;
            }
            
            .fieldset-title {
                margin-bottom: 4px !important;
            }
            
            .fieldset-title h4 {
                font-size: 0.9rem !important;
                margin: 0 0 1px 0 !important;
                line-height: 1.2 !important;
            }
            
            .fieldset-title p {
                font-size: 0.65rem !important;
                margin: 0 !important;
                line-height: 1.1 !important;
            }
            
            .field-grid {
                display: grid !important;
                grid-template-columns: repeat(3, 1fr) !important;
                gap: 6px !important;
            }
            
            .field {
                margin-bottom: 0 !important;
            }
            
            .field span {
                font-size: 0.65rem !important;
                margin-bottom: 1px !important;
                line-height: 1.1 !important;
            }
            
            .field-value {
                font-size: 0.75rem !important;
                padding: 3px 5px !important;
                line-height: 1.2 !important;
            }
        }
    </style>
</head>
<body>
    <div class="page">
        <article class="student-card">
            <div class="card-header">
                <div>
                    <h3>ព័ត៌មានលម្អិត | {{ $userinfo->name_kh }}</h3>
                </div>
                <div class="header-buttons no-print">
                    <button class="btn btn-primary" onclick="window.print()">
                        🖨️ បោះពុម្ព
                    </button>
                    <button class="btn btn-secondary" onclick="window.close()">
                        ✕ បិទ
                    </button>
                </div>
            </div>

            <!-- Profile Photo Section -->
            <div class="profile-photo-section">
                @if($userinfo->image)
                    <img src="{{ asset('storage/' . $userinfo->image) }}" alt="{{ $userinfo->name_kh }}" class="profile-photo">
                @else
                    <img src="https://ui-avatars.com/api/?name={{ urlencode($userinfo->name_kh) }}&background=4c5cff&color=fff&size=150" alt="{{ $userinfo->name_kh }}" class="profile-photo">
                @endif
            </div>

            <!-- Personal Information -->
            <div class="fieldset">
                <div class="fieldset-title">
                    <h4>ព័ត៌មានផ្ទាល់ខ្លួន</h4>
                    <p>អត្តសញ្ញាណ និងព័ត៌មានផ្ទាល់ខ្លួនទាំងអស់</p>
                </div>
                <div class="field-grid">
                    <div class="field">
                        <span>អត្តលេខ</span>
                        <div class="field-value">{{ $userinfo->id_number }}</div>
                    </div>
                    <div class="field">
                        <span>ឈ្មោះ (ខ្មែរ)</span>
                        <div class="field-value">{{ $userinfo->name_kh }}</div>
                    </div>
                    <div class="field">
                        <span>ឈ្មោះ (ឡាតាំង)</span>
                        <div class="field-value">{{ $userinfo->name_en }}</div>
                    </div>
                    <div class="field">
                        <span>លេខទូរស័ព្ទ</span>
                        <div class="field-value">{{ $userinfo->phone_number ?? '—' }}</div>
                    </div>
                    <div class="field">
                        <span>ថ្ងៃខែឆ្នាំកំណើត</span>
                        <div class="field-value">{{ $userinfo->dob ? \Carbon\Carbon::parse($userinfo->dob)->format('d/m/Y') : '—' }}</div>
                    </div>
                    @if($userinfo->monkType)
                        <div class="field">
                            <span>ប្រភេទសមាជិក</span>
                            <div class="field-value">{{ $userinfo->monkType->name }}</div>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Birth Address -->
            <div class="fieldset">
                <div class="fieldset-title">
                    <h4>ទីកន្លែងកំណើត</h4>
                    <p>អាសយដ្ឋានកំណើតរបស់អ្នក</p>
                </div>
                <div class="field-grid">
                    @if(optional($userinfo->province)->name)
                        <div class="field">
                            <span>ខេត្ត/ក្រុង</span>
                            <div class="field-value">{{ $userinfo->province->name }}</div>
                        </div>
                    @endif
                    @if(optional($userinfo->district)->name)
                        <div class="field">
                            <span>ស្រុក/ខណ្ឌ</span>
                            <div class="field-value">{{ $userinfo->district->name }}</div>
                        </div>
                    @endif
                    @if(optional($userinfo->commune)->name)
                        <div class="field">
                            <span>ឃុំ/សង្កាត់</span>
                            <div class="field-value">{{ $userinfo->commune->name }}</div>
                        </div>
                    @endif
                    @if(optional($userinfo->village)->name)
                        <div class="field">
                            <span>ភូមិ</span>
                            <div class="field-value">{{ $userinfo->village->name }}</div>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Current Address -->
            <div class="fieldset">
                <div class="fieldset-title">
                    <h4>អាសយដ្ឋានបច្ចុប្បន្ន</h4>
                    <p>ទីកន្លែងបច្ចុប្បន្នរបស់អ្នក</p>
                </div>
                <div class="field-grid">
                    @if($userinfo->temple_name)
                        <div class="field">
                            <span>ឈ្មោះវត្ត</span>
                            <div class="field-value">{{ $userinfo->temple_name }}</div>
                        </div>
                    @endif
                    @if(optional($userinfo->currentProvince)->name)
                        <div class="field">
                            <span>ខេត្ត/ក្រុង</span>
                            <div class="field-value">{{ $userinfo->currentProvince->name }}</div>
                        </div>
                    @endif
                    @if(optional($userinfo->currentDistrict)->name)
                        <div class="field">
                            <span>ស្រុក/ខណ្ឌ</span>
                            <div class="field-value">{{ $userinfo->currentDistrict->name }}</div>
                        </div>
                    @endif
                    @if(optional($userinfo->currentCommune)->name)
                        <div class="field">
                            <span>ឃុំ/សង្កាត់</span>
                            <div class="field-value">{{ $userinfo->currentCommune->name }}</div>
                        </div>
                    @endif
                    @if(optional($userinfo->currentVillage)->name)
                        <div class="field">
                            <span>ភូមិ</span>
                            <div class="field-value">{{ $userinfo->currentVillage->name }}</div>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Parent Information -->
            <div class="fieldset">
                <div class="fieldset-title">
                    <h4>ព័ត៌មានមាតាបិតា</h4>
                    <p>ព័ត៌មានអំពីមាតាបិតារបស់អ្នក</p>
                </div>
                <div class="field-grid">
                    @if($userinfo->father_name)
                        <div class="field">
                            <span>ឈ្មោះឪពុក</span>
                            <div class="field-value">{{ $userinfo->father_name }}</div>
                            @if($userinfo->father_job)
                                <div class="field-value" style="font-size: 0.9rem; color: var(--muted); margin-top: 0.25rem;">
                                    មុខរបរ: {{ $userinfo->father_job }}
                                </div>
                            @endif
                        </div>
                    @endif
                    @if($userinfo->mother_name)
                        <div class="field">
                            <span>ឈ្មោះម្តាយ</span>
                            <div class="field-value">{{ $userinfo->mother_name }}</div>
                            @if($userinfo->mother_job)
                                <div class="field-value" style="font-size: 0.9rem; color: var(--muted); margin-top: 0.25rem;">
                                    មុខរបរ: {{ $userinfo->mother_job }}
                                </div>
                            @endif
                        </div>
                    @endif
                </div>
            </div>

            <!-- Education Information -->
            <div class="fieldset">
                <div class="fieldset-title">
                    <h4>ព័ត៌មានការសិក្សា</h4>
                    <p>កម្រិតវប្បធម៌និងការសិក្សារបស់អ្នក</p>
                </div>
                <div class="field-grid">
                    @if(optional($userinfo->education)->name)
                        <div class="field">
                            <span>កម្រិតវប្បធម៌</span>
                            <div class="field-value">{{ $userinfo->education->name }}</div>
                        </div>
                    @endif
                    @if(optional($userinfo->educationYear)->name)
                        <div class="field">
                            <span>ឆ្នាំសិក្សា</span>
                            <div class="field-value">{{ $userinfo->educationYear->name }}</div>
                        </div>
                    @endif
                </div>
            </div>
        </article>
    </div>

    <style>
        /* Header Buttons Alignment */
        .header-buttons {
            display: flex;
            gap: 0.75rem;
            align-items: center;
        }
    </style>
</body>
</html>
