@extends('admin.components.app')
@section('content')
    @push('script')
        <script src="{{ asset('assets/js/kudi-filter.js') }}"></script>
    @endpush

    <div class="page">
        <section class="form-section">
            <div class="card mt-3 border-0 shadow-none bg-transparent">
                @include('admin.components.kudi-filter', [
                    'filterAction' => route('userinfo.index'),
                    'kudis' => $kudis,
                    'selectedKudiId' => $selectedKudiId,
                    'createRoute' => route('userinfo.create'),
                    'createLabel' => 'បង្កើតសមាជិកថ្មី',
                    'downloadRoute' => route('admin.export.members'),
                    'stats' => $stats ?? [],
                ])

                <div class="mt-3">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle mb-0 checkbox-all kudi-table" id="datatable_1" style="width: 100%; table-layout: auto;">
                            <thead>
                                <tr>
                                    <th>ល.រ</th>
                                    <th>រូបភាព</th>
                                    <th>អត្តលេខ</th>
                                    <th>ឈ្មោះ (ខ្មែរ)</th>
                                    <th>លេខទូរស័ព្ទ</th>
                                    <th>ភិក្ខុ/សាមណេរ</th>
                                    <th>កុដិ</th>
                                    <th>កម្រិតវប្បធម៌</th>
                                    <th class="text-end">សកម្មភាព</th>
                                </tr>
                            </thead>
                            <tbody id="user-table-body">
                                @include('User.partials.user_table', ['userinfo' => $userinfo])
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </section>

        <!-- Include User Detail Modal -->
        @include('User.partials.detail-modal')

        <!-- User Image Modal -->
        <div id="userImageModal" class="user-image-modal mt-4" onclick="closeUserImageModal()">
            <div class="user-modal-card" onclick="event.stopPropagation()">
                <div class="user-modal-header">
                    <h5 class="user-modal-title">
                        <i class="fas fa-image me-2"></i>
                        រូបភាពអ្នកប្រើប្រាស់
                    </h5>
                    <button type="button" class="user-modal-close" onclick="closeUserImageModal()">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <div class="user-modal-body">
                    <img id="userModalImage" src="" alt="User Image" class="user-modal-image">
                </div>
                <div class="user-modal-footer">
                    <button type="button" class="btn btn-secondary" onclick="closeUserImageModal()">
                        <i class="fas fa-times me-2"></i>បិទ
                    </button>
                </div>
            </div>
        </div>

       

       

    </div>

    <script>
        // User Image Modal Functions
        function openUserImageModal(imgElement, userName) {
            const modal = document.getElementById('userImageModal');
            const modalImage = document.getElementById('userModalImage');

            modalImage.src = imgElement.src;
            modalImage.alt = userName;
            modal.style.display = 'flex';
            document.body.style.overflow = 'hidden';
        }

        function closeUserImageModal() {
            const modal = document.getElementById('userImageModal');
            modal.style.display = 'none';
            document.body.style.overflow = 'auto';
        }

        // Make functions globally available
        window.openUserImageModal = openUserImageModal;
        window.closeUserImageModal = closeUserImageModal;

        // User Detail Modal Functions
        function showUserDetailModal(userId) {
            console.log('showUserDetailModal called with userId:', userId);
            const modal = document.getElementById('userDetailModal');
            const content = document.getElementById('userDetailContent');
            
            if (!modal || !content) {
                console.error('Modal elements not found!', { modal, content });
                return;
            }
            
            console.log('Modal element found, showing modal');
            
            // Show modal
            modal.style.display = 'flex';
            modal.classList.add('show');
            document.body.style.overflow = 'hidden';
            
            // Reset content
            content.innerHTML = '<div class="text-center py-4"><div class="loading-spinner"></div><p class="mt-2">កំពុកព័ត៌មាន...</p></div>';
            
            // Fetch user details
            console.log('Fetching user details for ID:', userId);
            const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');
            console.log('CSRF Token found:', !!csrfToken);
            
            const headers = {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            };
            
            if (csrfToken) {
                headers['X-CSRF-TOKEN'] = csrfToken;
            }
            
            console.log('Request URL:', `/userinfo/${userId}/detail`);
            console.log('Request headers:', headers);
            
            fetch(`/userinfo/${userId}/detail`, {
                method: 'GET',
                headers: headers
            })
            .then(response => {
                console.log('Fetch response:', response);
                if (!response.ok) {
                    throw new Error(`HTTP error! status: ${response.status}`);
                }
                return response.json();
            })
            .then(data => {
                console.log('Fetch data received:', data);
                if (data.success) {
                    console.log('Setting content HTML');
                    content.innerHTML = data.html;
                } else {
                    console.log('Server returned error:', data.message);
                    content.innerHTML = '<div class="alert alert-danger"><i class="fas fa-exclamation-triangle me-2"></i>' + (data.message || 'មិនអាចផ្ទុកព័ត៌មានបានទេ។') + '</div>';
                }
            })
            .catch(error => {
                console.error('Error fetching user details:', error);
                content.innerHTML = '<div class="alert alert-danger"><i class="fas fa-exclamation-triangle me-2"></i>មានបញ្ហាក្នុងការងផ្ទុកព័ត៌មាន។ សូមព្យាយាម្ដងទៀត។</div>';
            });
        }

        function closeUserDetailModal() {
            const modal = document.getElementById('userDetailModal');
            if (modal) {
                modal.style.display = 'none';
                modal.classList.remove('show');
                document.body.style.overflow = 'auto';
            }
        }

        // Make functions globally available
        window.showUserDetailModal = showUserDetailModal;
        window.closeUserDetailModal = closeUserDetailModal;
        
        // Event listeners
        document.addEventListener('DOMContentLoaded', function() {
            // Single click handler for both eye buttons and modal outside clicks
            document.body.addEventListener('click', function(e) {
                // Check if eye button was clicked
                const button = e.target.closest('.user-detail-btn');
                if (button) {
                    e.preventDefault();
                    e.stopPropagation();
                    console.log('Eye button clicked!', button);
                    const userId = button.getAttribute('data-user-id');
                    console.log('User ID:', userId);
                    if (userId) {
                        showUserDetailModal(userId);
                    }
                    return; // Stop processing other click handlers
                }
                
                // Handle modal outside clicks
                const modal = document.getElementById('userDetailModal');
                const container = document.querySelector('.custom-modal-content');
                
                // Only handle clicks if modal is visible and click is outside modal content
                if (modal && modal.classList.contains('show') && container && !container.contains(event.target)) {
                    closeUserDetailModal();
                }
            });
            
            // Handle escape key
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape') {
                    closeUserDetailModal();
                    closeUserImageModal();
                }
            });
        });
    </script>
@endsection

@pushOnce('css', 'kudi-table-styles')
    <style>
        .kudi-table-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 32px;
            padding: 1.5rem 1.75rem 2rem;
            box-shadow: 0 25px 60px rgba(89, 92, 150, 0.15);
            border: 1px solid rgba(255, 255, 255, 0.6);
            position: relative;
        }

        .kudi-table-card .table-responsive {
            max-height: 70vh;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }

        .kudi-table {
            border-collapse: separate;
            border-spacing: 0 8px;
            width: 100%;
            table-layout: fixed;
        }

        .kudi-table th {
            border: none;
            font-size: 0.72rem;
            text-transform: uppercase;
            letter-spacing: 0.08em;
            color: #6c7798;
            font-weight: 600;
            white-space: nowrap;
            padding: 0.75rem 1rem;
            text-align: left;
            background: rgba(255, 255, 255, 0.95);
            vertical-align: middle;
            width: 120px;
        }

        .kudi-table thead th:first-child {
            border-top-left-radius: 18px;
            border-bottom-left-radius: 18px;
            padding-left: 1.5rem;
        }

        .kudi-table thead th:last-child {
            border-top-right-radius: 18px;
            border-bottom-right-radius: 18px;
            text-align: right;
           
        }

        .kudi-table thead th:not(:first-child):not(:last-child) {
            padding-left: 1.5rem;
            padding-right: 1.5rem;
        }

        .kudi-table tbody tr {
            background: #fefefe;
            box-shadow: 0 10px 25px rgba(118, 127, 180, 0.12);
            border-radius: 18px;
        }

        .kudi-table tbody tr td,
        .kudi-table tbody tr th {
            border: none;
            vertical-align: middle;
            white-space: nowrap;
            padding: 0.75rem 1rem;
            text-align: left;
            background: rgba(255, 255, 255, 0.95);
        }

        .kudi-table tbody tr td:first-child,
        .kudi-table tbody tr th:first-child {
            border-top-left-radius: 18px;
            border-bottom-left-radius: 18px;
            padding-left: 1.5rem;
        }

        .kudi-table tbody tr td:last-child,
        .kudi-table tbody tr th:last-child {
            border-top-right-radius: 18px;
            border-bottom-right-radius: 18px;
            padding-right: 1.5rem;
        }

        .kudi-table tbody tr:hover {
            transform: translateY(-2px);
            transition: transform 0.2s ease, box-shadow 0.2s ease;
            box-shadow: 0 20px 35px rgba(93, 113, 182, 0.2);
        }

        .kudi-table-card img {
            width: 56px;
            height: 56px;
            border-radius: 14px;
            object-fit: cover;
            border: 2px solid rgba(255, 255, 255, 0.8);
            box-shadow: 0 6px 14px rgba(44, 62, 80, 0.2);
        }

        .kudi-table-glow {
            position: absolute;
            left: 10%;
            right: 10%;
            bottom: 0.5rem;
            height: 6px;
        }

        @keyframes glow {
            from { transform: scale(0.8); opacity: 0.5; }
            to { transform: scale(1.2); opacity: 0.8; }
        }

        .avatar-fit {
            width: 45px;
            height: 45px;
            object-fit: cover;
            border-radius: 12px;
            border: 2px solid #e9ecef;
            transition: all 0.3s ease;
        }

        .avatar-fit:hover {
            transform: scale(1.05);
            border-color: #007bff;
        }

        .user-image-modal {
            display: none;
            position: fixed;
            z-index: 10000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.8);
            cursor: pointer;
        }

        .user-modal-content {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            max-width: 90%;
            max-height: 90%;
        }

        .user-modal-content img {
            width: 100%;
            height: auto;
            border-radius: 8px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
        }

        .user-close-modal {
            position: absolute;
            top: 20px;
            right: 30px;
            color: white;
            font-size: 40px;
            font-weight: bold;
            cursor: pointer;
            background: rgba(0, 0, 0, 0.5);
            width: 50px;
            height: 50px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s ease;
        }

        .user-close-modal:hover {
            background: rgba(0, 0, 0, 0.8);
            transform: scale(1.1);
        }

        .empty-state-container {
            padding: 2rem 1rem;
            min-height: 150px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }

        .user-detail-btn {
            cursor: pointer !important;
            pointer-events: auto !important;
            z-index: 10 !important;
            position: relative !important;
            border: none !important;
            background: transparent !important;
            padding: 4px 8px !important;
            border-radius: 4px !important;
            transition: all 0.2s ease !important;
            display: inline-block !important;
            width: auto !important;
            height: auto !important;
        }

        .user-detail-btn:hover {
            background-color: rgba(0, 123, 255, 0.1) !important;
            transform: scale(1.1) !important;
        }

        .user-detail-btn:focus {
            outline: 2px solid rgba(0, 123, 255, 0.5) !important;
            outline-offset: 2px !important;
        }

        /* User Image Modal Styles */
        .user-image-modal {
            display: none;
            position: fixed;
            z-index: 99999;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.6);
            backdrop-filter: blur(5px);
            align-items: center;
            justify-content: center;
        }

        .user-modal-card {
            position: relative;
            background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
            margin: auto;
            padding: 0;
            border: 1px solid rgba(0, 0, 0, 0.1);
            border-radius: 16px;
            width: 95%;
            max-width: 600px;
            max-height: 90vh;
            overflow: hidden;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            animation: slideUp 0.4s ease;
            display: flex;
            flex-direction: column;
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(50px) scale(0.95);
            }
            to {
                opacity: 1;
                transform: translateY(0) scale(1);
            }
        }

        .user-modal-header {
            padding: 1rem 1.5rem;
            border-bottom: 1px solid #e9ecef;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 16px 16px 0 0;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 4px 20px rgba(102, 126, 234, 0.3);
        }

        .user-modal-title {
            margin: 0;
            font-size: 1.25rem;
            font-weight: 600;
            display: flex;
            align-items: center;
        }

        .user-modal-close {
            color: rgba(255, 255, 255, 0.8);
            font-size: 1.25rem;
            font-weight: bold;
            cursor: pointer;
            background: rgba(255, 255, 255, 0.1);
            border: none;
            padding: 0.25rem;
            border-radius: 50%;
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s ease;
        }

        .user-modal-close:hover {
            color: white;
            background: rgba(255, 255, 255, 0.2);
            transform: rotate(90deg);
        }

        .user-modal-body {
            padding: 2rem;
            display: flex;
            justify-content: center;
            align-items: center;
            background: #ffffff;
            flex: 1;
        }

        .user-modal-image {
            max-width: 100%;
            max-height: 60vh;
            object-fit: contain;
            border-radius: 12px;
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);
            border: 4px solid #667eea;
            transition: transform 0.3s ease;
        }

        .user-modal-image:hover {
            transform: scale(1.05);
        }

        .user-modal-footer {
            padding: 1rem 1.5rem;
            border-top: 1px solid #e9ecef;
            background-color: #f8f9fa;
            border-radius: 0 0 16px 16px;
            display: flex;
            justify-content: flex-end;
            gap: 0.5rem;
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.05);
        }

        @media (max-width: 768px) {
            .user-modal-card {
                width: 98%;
                max-height: 95vh;
                margin: 1rem;
            }
            
            .user-modal-image {
                max-height: 50vh;
            }
            
            .user-modal-header,
            .user-modal-footer {
                padding: 1rem;
            }
            
            .user-modal-body {
                padding: 1.5rem;
            }
        }

        .custom-modal {
            display: none;
            position: fixed;
            z-index: 10000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            backdrop-filter: blur(4px);
        }

        .custom-modal.show {
            display: flex !important;
            align-items: center;
            justify-content: center;
        }

        .custom-modal-content {
            position: relative;
            background-color: #fefefe;
            margin: auto;
            padding: 0;
            border: 1px solid #888;
            border-radius: 12px;
            width: 90%;
            max-width: 800px;
            max-height: 85vh;
            overflow: hidden;
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.3);
            animation: modalSlideIn 0.3s ease;
            display: flex;
            flex-direction: column;
        }

        @keyframes modalSlideIn {
            from {
                opacity: 0;
                transform: translateY(-50px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .custom-modal-header {
            padding: 1.5rem;
            border-bottom: 1px solid #dee2e6;
            background-color: #f8f9fa;
            border-radius: 12px 12px 0 0;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .custom-modal-title {
            margin: 0;
            font-size: 1.25rem;
            font-weight: 600;
            color: #212529;
        }

        .custom-modal-close {
            color: #6c757d;
            font-size: 1.5rem;
            font-weight: bold;
            cursor: pointer;
            background: none;
            border: none;
            padding: 0.5rem;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.2s ease;
        }

        .custom-modal-close:hover {
            color: #000;
            background-color: rgba(0, 0, 0, 0.1);
        }

        .custom-modal-body {
            padding: 0;
            overflow-y: auto;
            flex: 1;
        }

        .custom-modal-footer {
            padding: 1rem 1.5rem;
            border-top: 1px solid #dee2e6;
            background-color: #f8f9fa;
            border-radius: 0 0 12px 12px;
            text-align: right;
        }

        .loading-spinner {
            border: 3px solid #f3f3f3;
            border-top: 3px solid #007bff;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            animation: spin 1s linear infinite;
            margin: 0 auto;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Ensure empty state alignment works properly */
        .kudi-table tbody tr td[colspan] {
            padding: 0 !important;
            vertical-align: top !important;
        }

        .kudi-table tbody tr td[colspan] .empty-state-container {
            margin: 0.5rem 1.5rem !important;
            width: calc(100% - 3rem) !important;
        }

        .kudi-table tbody tr td[colspan] .empty-state-content {
            text-align: left !important;
            padding-left: 0 !important;
        }

        /* User Image Modal Styles */
        .user-image-modal {
            display: none;
            position: fixed;
            z-index: 10001;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.8);
            cursor: pointer;
            animation: fadeIn 0.3s ease;
        }

        .user-modal-content {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            max-width: 90%;
            max-height: 90%;
            animation: zoomIn 0.3s ease;
        }

        .user-modal-content img {
            width: 100%;
            height: auto;
            border-radius: 8px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
        }

        .user-close-modal {
            position: absolute;
            top: 20px;
            right: 30px;
            color: white;
            font-size: 40px;
            font-weight: bold;
            cursor: pointer;
            background: rgba(0, 0, 0, 0.5);
            width: 50px;
            height: 50px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s ease;
        }

        .user-close-modal:hover {
            background: rgba(0, 0, 0, 0.8);
            transform: scale(1.1);
        }

        @keyframes zoomIn {
            from {
                opacity: 0;
                transform: translate(-50%, -50%) scale(0.8);
            }
            to {
                opacity: 1;
                transform: translate(-50%, -50%) scale(1);
            }
        }
    </style>
@endpushOnce
