<?php

require_once 'vendor/autoload.php';

use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

// Fetch provinces from API
$url = "https://data.mef.gov.kh/api/v1/public-datasets/pd_66a8603700604c000123e144/json?page=1&page_size=25";
$response = file_get_contents($url);
$data = json_decode($response, true);


// Clear existing provinces
DB::statement('SET FOREIGN_KEY_CHECKS=0');
DB::table('province')->truncate();

$created_at = Carbon::now();
$provinces = [];

foreach ($data['items'] as $item) {
    $provinces[] = [
        'name' => $item['province_kh'],
        'created_at' => $created_at,
        'updated_at' => $created_at
    ];
}

// Insert provinces
DB::table('province')->insert($provinces);

echo "Successfully inserted " . count($provinces) . " provinces with Khmer names!\n";

?>
