<!DOCTYPE html>
<html>
<head>
    <title>Debug Location</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
</head>
<body>
    <h1>Debug Location Dropdown</h1>
    
    <form data-location-form>
        <select data-role="province" data-placeholder="Select Province">
            <option value="">Select Province</option>
            <option value="1">Phnom Penh</option>
        </select>
        
        <select data-role="district" 
            data-endpoint="{{ url('/api/provinces/:id/districts') }}"
            data-placeholder="Select District"
            data-disabled-placeholder="Select province first"
            disabled>
            <option value="">Select province first</option>
        </select>
    </form>
    
    <div id="debug-output"></div>
    
    <script>
        // Override console.log to show on page
        const debugDiv = document.getElementById('debug-output');
        const originalLog = console.log;
        console.log = function(...args) {
            originalLog.apply(console, args);
            if (debugDiv) {
                debugDiv.innerHTML += '<div>' + JSON.stringify(args) + '</div>';
            }
        };
        
        // Test basic JavaScript
        console.log('JavaScript working');
        
        // Test DOM elements
        document.addEventListener('DOMContentLoaded', function() {
            console.log('DOM loaded');
            
            const form = document.querySelector('form[data-location-form]');
            console.log('Form found:', !!form);
            
            const provinceSelect = document.querySelector('[data-role="province"]');
            const districtSelect = document.querySelector('[data-role="district"]');
            
            console.log('Province select found:', !!provinceSelect);
            console.log('District select found:', !!districtSelect);
            
            if (provinceSelect) {
                provinceSelect.addEventListener('change', function() {
                    console.log('Province changed to:', this.value);
                    
                    if (districtSelect && this.value) {
                        console.log('Should load districts for province:', this.value);
                        console.log('District endpoint:', districtSelect.dataset.endpoint);
                        
                        // Test fetch directly
                        fetch(districtSelect.dataset.endpoint.replace(':id', this.value))
                            .then(response => {
                                console.log('Fetch response status:', response.status);
                                return response.json();
                            })
                            .then(data => {
                                console.log('Fetch data:', data);
                            })
                            .catch(error => {
                                console.log('Fetch error:', error);
                            });
                    }
                });
            }
        });
    </script>
</body>
</html>
