<?php

namespace Database\Seeders;

use Database\Seeders\Concerns\LoadsCambodiaGeography;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CommuneSeeder extends Seeder
{
    use LoadsCambodiaGeography;

    public function run(): void
    {
        $now = now();
        $rows = [];

        foreach ($this->geographyData() as $province) {
            foreach ($province['districts'] ?? [] as $district) {
                $districtId = $this->codeToId($district['code']);

                foreach ($district['communes'] ?? [] as $commune) {
                    $rows[] = [
                        'id'          => $this->codeToId($commune['code']),
                        'district_id' => $districtId,
                        'name'        => $this->khmerName($commune),
                        'created_at'  => $now,
                        'updated_at'  => $now,
                    ];
                }
            }
        }

        foreach (array_chunk($rows, 500) as $chunk) {
            DB::table('commune')->upsert(
                $chunk,
                ['id'],
                ['district_id', 'name', 'updated_at']
            );
        }
    }
}
