<?php

namespace Database\Seeders;

use Database\Seeders\Concerns\LoadsCambodiaGeography;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ProvinceSeeder extends Seeder
{
    use LoadsCambodiaGeography;

    public function run(): void
    {
        $now = now();
        $rows = [];

        foreach ($this->geographyData() as $province) {
            $rows[] = [
                'id'         => $this->codeToId($province['code']),
                'name'       => $this->khmerName($province),
                'created_at' => $now,
                'updated_at' => $now,
            ];
        }

        foreach (array_chunk($rows, 100) as $chunk) {
            DB::table('province')->upsert(
                $chunk,
                ['id'],
                ['name', 'updated_at']
            );
        }
    }
}
