<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class DistrictTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
      // reset district table
      DB::statement('SET FOREIGN_KEY_CHECKS=0');
      DB::table('district')->truncate();

      $created_at = Carbon::now();
      $districts = [
        ['province_id' => 1, 'name' => 'Chamkar Mon', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['province_id' => 1, 'name' => 'Doun Penh', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['province_id' => 1, 'name' => 'Prampir Meakkakra', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['province_id' => 1, 'name' => 'Toul Kok', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['province_id' => 1, 'name' => 'Dang Kor', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['province_id' => 1, 'name' => 'Mean Chey', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['province_id' => 1, 'name' => 'Russey Keo', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['province_id' => 1, 'name' => 'Sen Sok', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['province_id' => 1, 'name' => 'Por Senchey', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['province_id' => 1, 'name' => 'Chroy Chongvar', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['province_id' => 1, 'name' => 'Prek Pnov', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['province_id' => 1, 'name' => 'Chbar Ampov', 'created_at' => $created_at, 'updated_at' => $created_at],
        ['province_id' => 1, 'name' => 'Boeng Keng Kang', 'created_at' => $created_at, 'updated_at' => $created_at]
      ];

      DB::table('district')->insert($districts);
    }
}
