<?php

namespace Database\Seeders;

use Database\Seeders\Concerns\LoadsCambodiaGeography;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DistrictSeeder extends Seeder
{
    use LoadsCambodiaGeography;

    public function run(): void
    {
        $now = now();
        $rows = [];

        foreach ($this->geographyData() as $province) {
            $provinceId = $this->codeToId($province['code']);

            foreach ($province['districts'] ?? [] as $district) {
                $rows[] = [
                    'id'          => $this->codeToId($district['code']),
                    'province_id' => $provinceId,
                    'name'        => $this->khmerName($district),
                    'created_at'  => $now,
                    'updated_at'  => $now,
                ];
            }
        }

        foreach (array_chunk($rows, 500) as $chunk) {
            DB::table('district')->upsert(
                $chunk,
                ['id'],
                ['province_id', 'name', 'updated_at']
            );
        }
    }
}
