<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class CompleteDistrictSeeder extends Seeder
{
    public function run()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0');
        DB::table('district')->truncate();

        $created_at = Carbon::now();
        
        $districts = [
            // Phnom Penh (1)
            ['province_id' => 1, 'name' => 'Chamkar Mon', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 1, 'name' => 'Doun Penh', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 1, 'name' => 'Prampir Meakkakra', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 1, 'name' => 'Toul Kok', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 1, 'name' => 'Dang Kor', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 1, 'name' => 'Mean Chey', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 1, 'name' => 'Russey Keo', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 1, 'name' => 'Sen Sok', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 1, 'name' => 'Por Senchey', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 1, 'name' => 'Chroy Chongvar', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 1, 'name' => 'Prek Pnov', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 1, 'name' => 'Chbar Ampov', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 1, 'name' => 'Boeng Keng Kang', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Banteay Meanchey (2)
            ['province_id' => 2, 'name' => 'Serei Saophoan', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 2, 'name' => 'Mongkol Borei', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 2, 'name' => 'Phnom Srok', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 2, 'name' => 'Preah Netr Preah', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 2, 'name' => 'Ou Chrov', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 2, 'name' => 'Bavel', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 2, 'name' => 'Svay Chek', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 2, 'name' => 'Malai', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 2, 'name' => 'Thma Puok', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Battambang (3)
            ['province_id' => 3, 'name' => 'Battambang', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 3, 'name' => 'Thma Koul', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 3, 'name' => 'Bavel', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 3, 'name' => 'Sangkae', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 3, 'name' => 'Samlout', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 3, 'name' => 'Rukhak Kiri', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 3, 'name' => 'Mongkol Borei', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 3, 'name' => 'Kamrieng', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 3, 'name' => 'Ek Phnom', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 3, 'name' => 'Banan', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 3, 'name' => 'Aek Phnum', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 3, 'name' => 'Koas Krala', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 3, 'name' => 'Rattanak Mondol', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 3, 'name' => 'Bavel', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Kampong Cham (4)
            ['province_id' => 4, 'name' => 'Kampong Cham', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 4, 'name' => 'Batheay', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 4, 'name' => 'Cheung Prey', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 4, 'name' => 'Kampong Siem', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 4, 'name' => 'Krouch Chhmar', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 4, 'name' => 'Memot', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 4, 'name' => 'Ou Reang Ov', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 4, 'name' => 'Prey Chhor', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 4, 'name' => 'Srei Santhor', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 4, 'name' => 'Stueng Trang', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 4, 'name' => 'Suong', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 4, 'name' => 'Tboung Khmum', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Kampong Chhnang (5)
            ['province_id' => 5, 'name' => 'Kampong Chhnang', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 5, 'name' => 'Baribour', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 5, 'name' => 'Cholkiri', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 5, 'name' => 'Kampong Leaeng', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 5, 'name' => 'Kampong Tralach', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 5, 'name' => 'Rolea Bier', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 5, 'name' => 'Sameakki Mean Chey', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 5, 'name' => 'Tuek Phos', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Kampong Speu (6)
            ['province_id' => 6, 'name' => 'Kampong Speu', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 6, 'name' => 'Basedth', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 6, 'name' => 'Kong Pisei', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 6, 'name' => 'Aoral', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 6, 'name' => 'Odongk', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 6, 'name' => 'Phnum Srouch', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 6, 'name' => 'Samraong Tong', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 6, 'name' => 'Thpong', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Kampong Thom (7)
            ['province_id' => 7, 'name' => 'Stung Sen', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 7, 'name' => 'Baray', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 7, 'name' => 'Kampong Svay', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 7, 'name' => 'Kampong Thla', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 7, 'name' => 'Prasat Balangk', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 7, 'name' => 'Prasat Sambour', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 7, 'name' => 'Sandan', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 7, 'name' => 'Santuk', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 7, 'name' => 'Stueng Saen', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Kampot (8)
            ['province_id' => 8, 'name' => 'Kampot', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 8, 'name' => 'Angkor Chey', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 8, 'name' => 'Banteay Meas', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 8, 'name' => 'Chhuk', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 8, 'name' => 'Chhouk', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 8, 'name' => 'Dang Tong', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 8, 'name' => 'Kampong Trach', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 8, 'name' => 'Kamchay Mear', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Kandal (9)
            ['province_id' => 9, 'name' => 'Ta Khmau', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 9, 'name' => 'Kandal Stung', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 9, 'name' => 'Kien Svay', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 9, 'name' => 'Koh Thum', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 9, 'name' => 'Leuk Daek', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 9, 'name' => 'Lvea Em', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 9, 'name' => 'Mukh Kampul', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 9, 'name' => 'Angk Snuol', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 9, 'name' => 'Ponhea Lueu', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 9, 'name' => 'Saang', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Koh Kong (10)
            ['province_id' => 10, 'name' => 'Koh Kong', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 10, 'name' => 'Kiri Sakor', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 10, 'name' => 'Botum Sakor', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 10, 'name' => 'Sre Ambel', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 10, 'name' => 'Mondol Seima', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 10, 'name' => 'Thma Bang', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Kep (11)
            ['province_id' => 11, 'name' => 'Damnak Chang\'aeur', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Kratie (12)
            ['province_id' => 12, 'name' => 'Kratie', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 12, 'name' => 'Chhloung', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 12, 'name' => 'Prek Prasab', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 12, 'name' => 'Sambour', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 12, 'name' => 'Snuol', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 12, 'name' => 'Chitr Borei', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Mondulkiri (13)
            ['province_id' => 13, 'name' => 'Sen Monorom', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 13, 'name' => 'Kaoh Nheaek', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 13, 'name' => 'Oreang', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 13, 'name' => 'Pich Chenda', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 13, 'name' => 'Buon Ma', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 13, 'name' => 'Keo Seima', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Oddar Meanchey (14)
            ['province_id' => 14, 'name' => 'Samraong', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 14, 'name' => 'Banteay Ampil', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 14, 'name' => 'Chong Kal', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 14, 'name' => 'Trapeang Prasat', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 14, 'name' => 'Anlong Veaeng', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Pailin (15)
            ['province_id' => 15, 'name' => 'Pailin', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 15, 'name' => 'Sala Krau', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Preah Sihanouk (16)
            ['province_id' => 16, 'name' => 'Sihanoukville', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 16, 'name' => 'Prey Nob', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 16, 'name' => 'Stueng Hav', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 16, 'name' => 'Kampong Seila', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Preah Vihear (17)
            ['province_id' => 17, 'name' => 'Tbeng Meanchey', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 17, 'name' => 'Chey Saen', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 17, 'name' => 'Chheb', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 17, 'name' => 'Choam Khsant', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 17, 'name' => 'Kuleaen', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 17, 'name' => 'Rovieng', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 17, 'name' => 'Sangkum Thmei', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Pursat (18)
            ['province_id' => 18, 'name' => 'Pursat', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 18, 'name' => 'Bakan', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 18, 'name' => 'Kandieng', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 18, 'name' => 'Krakor', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 18, 'name' => 'Phnom Kravanh', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 18, 'name' => 'Sampov Meas', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 18, 'name' => 'Veal Veaeng', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Prey Veng (19)
            ['province_id' => 19, 'name' => 'Prey Veng', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 19, 'name' => 'Kampong Leav', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 19, 'name' => 'Peam Chor', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 19, 'name' => 'Peam Ro', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 19, 'name' => 'Pea Reang', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 19, 'name' => 'Preah Sdach', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 19, 'name' => 'Romeas Hek', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 19, 'name' => 'Sithor Kandal', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 19, 'name' => 'Svay Antor', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 19, 'name' => 'Svay Chrum', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 19, 'name' => 'Kampong Trabaek', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 19, 'name' => 'Mesang', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Ratanakiri (20)
            ['province_id' => 20, 'name' => 'Banlung', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 20, 'name' => 'Lumphat', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 20, 'name' => 'Koun Mom', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 20, 'name' => 'O Chum', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 20, 'name' => 'O Yadav', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 20, 'name' => 'Ta Veaeng', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 20, 'name' => 'Veun Sai', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 20, 'name' => 'Andong Meas', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 20, 'name' => 'Kon Mom', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Siem Reap (21)
            ['province_id' => 21, 'name' => 'Siem Reap', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 21, 'name' => 'Angkor Chum', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 21, 'name' => 'Angkor Thum', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 21, 'name' => 'Banteay Srei', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 21, 'name' => 'Chi Kraeng', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 21, 'name' => 'Kralanh', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 21, 'name' => 'Puok', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 21, 'name' => 'Prasat Bakong', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 21, 'name' => 'Sout Nikom', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 21, 'name' => 'Svay Leu', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 21, 'name' => 'Varin', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Stung Treng (22)
            ['province_id' => 22, 'name' => 'Stung Treng', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 22, 'name' => 'Siem Bouk', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 22, 'name' => 'Siem Pang', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 22, 'name' => 'Thala Barivat', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Svay Rieng (23)
            ['province_id' => 23, 'name' => 'Svay Rieng', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 23, 'name' => 'Chantrea', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 23, 'name' => 'Kampong Ro', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 23, 'name' => 'Romeas Hek', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 23, 'name' => 'Svay Chrum', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 23, 'name' => 'Svay Theab', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Takeo (24)
            ['province_id' => 24, 'name' => 'Takeo', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 24, 'name' => 'Bati', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 24, 'name' => 'Borei Cholsar', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 24, 'name' => 'Kiri Vong', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 24, 'name' => 'Koh Andet', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 24, 'name' => 'Doun Kaev', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 24, 'name' => 'Krasang', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 24, 'name' => 'Prey Kabbas', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 24, 'name' => 'Samraong', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 24, 'name' => 'Treang', 'created_at' => $created_at, 'updated_at' => $created_at],
            
            // Tbong Khmum (25)
            ['province_id' => 25, 'name' => 'Suong', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 25, 'name' => 'Dambae', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 25, 'name' => 'Krouch Chhmar', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 25, 'name' => 'Memot', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 25, 'name' => 'Ou Reang Ov', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 25, 'name' => 'Ponhea Kraek', 'created_at' => $created_at, 'updated_at' => $created_at],
            ['province_id' => 25, 'name' => 'Tboung Khmum', 'created_at' => $created_at, 'updated_at' => $created_at]
        ];

        DB::table('district')->insert($districts);
    }
}
