<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class CommuneTableSeeder extends Seeder
{
  /**
  * Run the database seeds.
  *
  * @return void
  */
  public function run()
  {
    // reset commune table
    DB::statement('SET FOREIGN_KEY_CHECKS=0');
    DB::table('commune')->truncate();

    $created_at = Carbon::now();
    $communes = [
      ['district_id' => 1, 'name' => 'Tonle Basak', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 1, 'name' => 'Boeng Trabek', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 1, 'name' => 'Phsar Doeum Thkov', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 1, 'name' => 'Toul Tum Poung 1', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 1, 'name' => 'Toul Tum Poung 2', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 2, 'name' => 'Sraas Chak', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 2, 'name' => 'Wat Phnom', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 2, 'name' => 'Phsar Chas', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 2, 'name' => 'Phsar Kandal 1', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 2, 'name' => 'Phsar Kandal 2', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 2, 'name' => 'Chey Chumneas', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 2, 'name' => 'Chak Tomuk', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 2, 'name' => 'Phsar Thmei 1', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 2, 'name' => 'Phsar Thmei 2', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 2, 'name' => 'Phsar Thmei 3', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 2, 'name' => 'Boeng Raing', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 3, 'name' => 'Monorom', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 3, 'name' => 'Mittapheap', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 3, 'name' => 'Veal Vong', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 3, 'name' => 'Orussei 1', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 3, 'name' => 'Orussei 2', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 3, 'name' => 'Orussei 3', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 3, 'name' => 'Orussei 4', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 3, 'name' => 'Boeng Prolit', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 4, 'name' => 'Boengkok 1', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 4, 'name' => 'Boengkok 2', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 4, 'name' => 'Phsar Depo 1', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 4, 'name' => 'Phsar Depo 2', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 4, 'name' => 'Phsar Depo 3', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 4, 'name' => 'Tuk Laak 1', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 4, 'name' => 'Tuk Laak 2', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 4, 'name' => 'Tuk Laak 3', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 4, 'name' => 'Phsar Doeumkor', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 4, 'name' => 'Boengsalang', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 5, 'name' => 'Dang Kor', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 5, 'name' => 'Cheung Ek', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 5, 'name' => 'Prek Kampeus', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 5, 'name' => 'Kong Noy', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 5, 'name' => 'Spean Thmar', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 5, 'name' => 'Roluos', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 5, 'name' => 'Porng Teuk', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 5, 'name' => 'Prey Veng', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 5, 'name' => 'Tien', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 5, 'name' => 'Prey Sar', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 5, 'name' => 'Kraing Pongro', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 5, 'name' => 'Pratas Lang', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 5, 'name' => 'Sac Sampeou', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 6, 'name' => 'Boeng Tumpun', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 6, 'name' => 'Stoeung Meanchey', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 6, 'name' => 'Chak Angre Krom', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 6, 'name' => 'Chak Angre Leu', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 7, 'name' => 'Russei Keo', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 7, 'name' => 'Toul Sang Kae', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 7, 'name' => 'Kilometer 6', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 7, 'name' => 'Chrang Chamres 1', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 7, 'name' => 'Chrang Chamres 2', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 7, 'name' => 'Svay Pak', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 8, 'name' => 'Phnom Penh Thmei', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 8, 'name' => 'Teuk Thlar', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 8, 'name' => 'Khmounh', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 8, 'name' => 'Kraing Thnoung', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 9, 'name' => 'Chom Chao', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 9, 'name' => 'Kakap', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 9, 'name' => 'Trapeang Krasaing', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 9, 'name' => 'Phleung Chheh Roteh', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 9, 'name' => 'Samraong Kraom', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 9, 'name' => 'Boeng Thom', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 9, 'name' => 'Kamboul', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 9, 'name' => 'Kantaok', 'created_at' => $created_at, 'updated_at' => $created_at],
      ['district_id' => 9, 'name' => 'Ovlaok', 'created_at' => $created_at, 'updated_at' => $created_at],
      ];

    DB::table('commune')->insert($communes);
  }
}
