<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Http;

class ApiProvinceSeeder extends Seeder
{
    public function run()
    {
        // Fetch provinces from API
        $url = "https://data.mef.gov.kh/api/v1/public-datasets/pd_66a8603700604c000123e144/json?page=1&page_size=25";
        $response = Http::get($url);
        $data = $response->json();

        // Clear existing provinces
        DB::statement('SET FOREIGN_KEY_CHECKS=0');
        DB::table('province')->truncate();

        $created_at = Carbon::now();
        $provinces = [];

        foreach ($data['items'] as $item) {
            $provinces[] = [
                'id' => (int)$item['province_code'], // Use province_code as integer ID
                'name' => $item['province_kh'],
                'created_at' => $created_at,
                'updated_at' => $created_at
            ];
        }

        // Insert provinces with explicit IDs
        DB::table('province')->insert($provinces);

        $this->command->info("Successfully inserted " . count($provinces) . " provinces with Khmer names!");
    }
}
