<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Http;

class ApiDistrictSeeder extends Seeder
{
    public function run()
    {
        // Clear existing districts
        DB::statement('SET FOREIGN_KEY_CHECKS=0');
        DB::table('district')->truncate();

        $created_at = Carbon::now();
        $allDistricts = [];
        $page = 1;
        $totalPages = 21;

        // Fetch all pages
        for ($page = 1; $page <= $totalPages; $page++) {
            $url = "https://data.mef.gov.kh/api/v1/public-datasets/pd_66a8603800604c000123e145/json?page={$page}&page_size=10";
            $response = Http::get($url);
            $data = $response->json();

            if (isset($data['items'])) {
                foreach ($data['items'] as $item) {
                    $allDistricts[] = [
                        'id' => (int)$item['district_code'], // Use district_code as integer ID
                        'province_id' => (int)$item['province_code'], // Convert to integer
                        'name' => $item['district_kh'],
                        'created_at' => $created_at,
                        'updated_at' => $created_at
                    ];
                }
                $this->command->info("Fetched page {$page} with " . count($data['items']) . " districts");
            }
        }

        // Insert all districts with explicit IDs
        DB::table('district')->insert($allDistricts);

        $this->command->info("Successfully inserted " . count($allDistricts) . " districts with Khmer names!");
    }
}
