<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Http;

class ApiCommuneSeeder extends Seeder
{
    public function run()
    {
        // Clear existing communes
        DB::statement('SET FOREIGN_KEY_CHECKS=0');
        DB::table('commune')->truncate();

        $created_at = Carbon::now();
        $allCommunes = [];
        $totalPages = 167; // Approximate pages for 1661 communes

        // Fetch all pages
        for ($page = 1; $page <= $totalPages; $page++) {
            $url = "https://data.mef.gov.kh/api/v1/public-datasets/pd_66a8603900604c000123e146/json?page={$page}&page_size=10";
            $response = Http::get($url);
            $data = $response->json();

            if (isset($data['items'])) {
                foreach ($data['items'] as $item) {
                    $allCommunes[] = [
                        'id' => (int)$item['commune_code'], // Use commune_code as integer ID
                        'district_id' => (int)$item['district_code'], // Convert to integer
                        'name' => $item['commune_kh'],
                        'created_at' => $created_at,
                        'updated_at' => $created_at
                    ];
                }
                $this->command->info("Fetched page {$page} with " . count($data['items']) . " communes");
                
                // Stop if we've reached the last page
                if ($data['page'] >= $data['total_pages']) {
                    break;
                }
            }
        }

        // Insert all communes with explicit IDs
        DB::table('commune')->insert($allCommunes);

        $this->command->info("Successfully inserted " . count($allCommunes) . " communes with Khmer names!");
    }
}
