<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('user_info', function (Blueprint $table) {
            $table->string('father_name')->nullable()->after('father_id');
            $table->string('father_job')->nullable()->after('father_name');
            $table->string('mother_name')->nullable()->after('mother_id');
            $table->string('mother_job')->nullable()->after('mother_name');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('user_info', function (Blueprint $table) {
            $table->dropColumn(['father_name', 'father_job', 'mother_name', 'mother_job']);
        });
    }
};
