<?php

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Support\Facades\DB;

// Get all provinces with their districts
echo "=== Current Administrative Divisions ===\n\n";

// Get all provinces with district counts
$provinces = DB::table('province')
    ->leftJoin('district', 'province.id', '=', 'district.province_id')
    ->select('province.id', 'province.name', DB::raw('COUNT(district.id) as district_count'))
    ->groupBy('province.id', 'province.name')
    ->orderBy('province.name')
    ->get();

echo "=== Provinces and District Counts ===\n";
foreach ($provinces as $province) {
    echo "- {$province->name}: {$province->district_count} districts\n";}

// Let the user choose a province to see detailed district info
echo "\nEnter a province ID to see its districts (or press Enter to exit): ";
$handle = fopen ("php://stdin","r");
$line = fgets($handle);
$provinceId = trim($line);

if (is_numeric($provinceId)) {
    $districts = DB::table('district')
        ->where('province_id', $provinceId)
        ->orderBy('name')
        ->get();
    
    $province = DB::table('province')->find($provinceId);
    
    if ($province) {
        echo "\n=== Districts in {$province->name} ===\n";
        foreach ($districts as $district) {
            $communeCount = DB::table('commune')
                ->where('district_id', $district->id)
                ->count();
                
            echo "- {$district->name} (ID: {$district->id}, Communes: {$communeCount})\n";
        }
    } else {
        echo "\n❌ Province not found.\n";
    }
}

echo "\n=== Check Complete ===\n";
