<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class UserModel extends Authenticatable
{
    use HasFactory, Notifiable;

    protected $table = 'user';

    protected $fillable = [
        'name',
        'password',
        'role',
        'image',
        'date_of_birth',
        'kudi_id'
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    public function kudi()
    {
        return $this->belongsTo(KudiModel::class, 'kudi_id');
    }

    public function userInfo()
    {
        return $this->hasOne(UserInfoModel::class, 'user_id');
    }

    public function hasRole($role)
    {
        $userRole = strtolower($this->role ?? '');
        
        if ($role === 'super_admin') {
            return in_array($userRole, ['super admin', 'superadmin', 'super_admin']);
        }
        
        if ($role === 'admin') {
            return $userRole === 'admin';
        }
        
        return $userRole === strtolower($role);
    }
}
