<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\Education;
use App\Models\MotherModel;
use App\Models\FatherModel;
use App\Models\KudiModel;
use App\Models\Province;
use App\Models\District;
use App\Models\Commune;
use App\Models\Village;
use App\Models\UserModel;

class UserInfoModel extends Model
{
    protected $table = 'user_info';
    protected $guarded = [];

    public function user()
    {
        return $this->belongsTo(UserModel::class, 'user_id');
    }

    public function education()
    {
        return $this->belongsTo(Education::class);
    }

    public function educationYear()
    {
        return $this->belongsTo(EducationYear::class);
    }

    public function monkType()
    {
        return $this->belongsTo(MonkType::class);
    }

    public function mother()
    {
        return $this->belongsTo(MotherModel::class);
    }

    public function father()
    {
        return $this->belongsTo(FatherModel::class);
    }

    public function kudi()
    {
        return $this->belongsTo(KudiModel::class);
    }

    public function province()
    {
        return $this->belongsTo(Province::class);
    }

    public function district()
    {
        return $this->belongsTo(District::class);
    }

    public function commune()
    {
        return $this->belongsTo(Commune::class);
    }

    public function village()
    {
        return $this->belongsTo(Village::class);
    }

    // Current address relationships
    public function currentProvince()
    {
        return $this->belongsTo(Province::class, 'current_province_id');
    }

    public function currentDistrict()
    {
        return $this->belongsTo(District::class, 'current_district_id');
    }

    public function currentCommune()
    {
        return $this->belongsTo(Commune::class, 'current_commune_id');
    }

    public function currentVillage()
    {
        return $this->belongsTo(Village::class, 'current_village_id');
    }
}
