<?php

namespace App\Http\Controllers;

use App\Models\Commune;
use App\Models\Village;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;

class VillageController extends Controller
{
    public function index()
    {
        $vil = Village::with('commune')->paginate(10);
        return view('admin.village.index', compact('vil'));
    }
    public function create(Request $request)
    {
        if ($request->isMethod('post')) {
            $this->save($request);
            return redirect()->route('village.index');
        }
        $com = Commune::all();
        $vil = new Village();
        return view('admin.village.form', compact('vil', 'com'));
    }
    public function edit(Request $request, $id)
    {
        $vil = Village::find($id);
        if ($request->isMethod('post')) {
            $this->save($request, $id);
            return redirect()->route('village.index');
        }
        $com = Commune::all();
        return view('admin.village.form', compact('vil', 'com'));
    }
    public function delete($id)
    {
        $vil = Village::find($id);
        $vil->delete();
        return redirect()->route('village.index');
    }
    private function save(Request $request, $id = null)
    {
        $validated = $request->validate([
            'name' => 'required',
            'commune_id' => 'required|exists:commune,id'
        ]);

        $data = $request->only(['name', 'commune_id']);
        if ($id) {
            $vil = Village::find($id);
        }
        if ($id) {
            $vil->update($data);
        } else {
            $vil = Village::create($data);
        }
    }
}
