<?php

namespace App\Http\Controllers;

use App\Models\Province;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Illuminate\Routing\Controller;

class ProvinceController extends Controller
{
    public function index()
    {
        $pro = Province::paginate(10);
        return view('admin.province.index', compact('pro'));
    }
    public function create(Request $request)
    {
        if ($request->isMethod('post')) {
            $this->save($request);
            return redirect()->route('province.index');
        }
        return view('admin.province.form');
    }
    public function edit(Request $request, $id)
    {

        $pro = Province::find($id);
        if ($request->isMethod('post')) {
            $this->save($request, $id);
            return redirect()->route('province.index');
        }
        return view('admin.province.form', compact('pro'));
    }
    private function save(Request $request, $id = null)
    {
        $validated = $request->validate([
            'name' => 'required',

        ]);

        $data = $request->only(['name']);


        if ($id) {
            $user = Province::find($id);
        }

        if ($id) {
            $user->update($data);
        } else {
            $user = Province::create($data);
        }
    }
    public function delete($id)
    {
        $pro = Province::find($id);


        $pro->delete();
        return redirect()->route('province.index');
    }
}
