<?php

namespace App\Http\Controllers;

use App\Models\UserModel;
use App\Models\KudiModel;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class Login extends Controller
{
    public function login(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'password' => 'required',
        ]);

        $user = UserModel::with('kudi')->where('name', $request->name)->first();

        if($user && Hash::check($request->password, $user->password)) {
            session([
                'user_id' => $user->id,
                'kudi_id' => $user->kudi_id,
                'user_name' => $user->name,
                'user_role' => $user->role,
                'image' => $user->image,
                'kudi_number' => $user->kudi ? $user->kudi->kudi_number : null
            ]);
            return redirect()->route('dashboard.index')->with('success', 'ចូលគណនីបានជោគជ័យ');
        }

        return redirect()->route('login.form')->with('error', 'ឈ្មោះ ឬ ពាក្យសម្ងាត់មិនត្រឹមត្រូវ');
    }

    public function logout(Request $request)
    {
        $request->session()->flush();
        return redirect()->route('login.form')->with('success', 'ចេញពីគណនីបានជោគជ័យ');
    }
}
