<?php

namespace App\Http\Controllers;

use App\Models\KudiModel;
use App\Models\kudi;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Illuminate\Routing\Controller;

class KudiController extends Controller
{
    public function index()
    {
        $kudi = KudiModel::orderByRaw('CAST(kudi_number AS UNSIGNED)')->get();
        return view('admin.kudi.index', compact('kudi'));
    }
    public function create(Request $request)
    {
        if ($request->isMethod('post')) {
            $this->save($request);
            return redirect()->route('kudi.index');
        }
        return view('admin.kudi.form');
    }
    public function edit(Request $request, $id)
    {

        $kudi =  KudiModel::find($id);
        if ($request->isMethod('post')) {
            $this->save($request, $id);
            return redirect()->route('kudi.index');
        }
        return view('admin.kudi.form', compact('kudi'));
    }
    private function save(Request $request, $id = null)
    {
        $validated = $request->validate([
            'kudi_number' => 'required',

        ]);

        $data = $request->only(['kudi_number']);


        if ($id) {
            $kudi =  KudiModel::find($id);
        }

        if ($id) {
            $kudi->update($data);
        } else {
            $kudi =  KudiModel::create($data);
        }
    }
    public function delete($id)
    {
        $kudi =  KudiModel::find($id);


        $kudi->delete();
        return redirect()->route('kudi.index');
    }
}
