<?php

namespace App\Http\Controllers;

use App\Models\Education;
use Illuminate\Http\Request;

class EducationController extends Controller
{

    public function index()
    {
        $edu = Education::all();
        return view('admin.educate.index',compact('edu'));
    }
    public function create(Request $request)
    {
        if ($request->isMethod('post')) {
            $this->save($request);
            return redirect()->route('education.index');
        }
        $edu = new Education();
        return view('admin.educate.form',compact('edu'));
    }

    public function edit(Request $request, $id)
    {
        $edu = Education::find($id);
        if ($request->isMethod('post')) {
            $this->save($request, $id);
            return redirect()->route('education.index');
        }
        return view('admin.educate.form',compact('edu'));
    }
private function save(Request $request, $id = null){
        $validated = $request->validate([
            'name' => 'required',
        ]);
        $data = $request->only(['name']);
        if($id){
            $edu = Education::find($id);
        }
        if($id){
            $edu->update($data);
        }else{
            $edu = Education::create($data);
        }
    }
    public function delete($id)
    {
        $edu = Education::find($id);
        $edu->delete();
        return redirect()->route('education.index');
    }
}
