<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Illuminate\Routing\Controller;
use App\Models\District;
use App\Models\Province;

class DistrictController extends Controller
{
    public function index()
    {
        $dis = District::with('province')->paginate(10);

        return view('admin.district.index', compact('dis'));
    }
    public function create(Request $request)
    {
        if ($request->isMethod('post')) {
            $this->save($request);
            return redirect()->route('district.index');
        }
        $pro=Province::all();
         $dis = new District();
        return view('admin.district.form', compact('dis','pro'));
    }
    public function edit(Request $request, $id)
    {
        $dis = District::find($id);
        if($request->isMethod('post')) {
            $this->save($request, $id);
            return redirect()->route('district.index');
        }
        $pro=Province::all();

        return view('admin.district.form', compact('dis', 'pro'));
    }
    public function delete($id){
        $dis = District::find($id);
        $dis->delete();
        return redirect()->route('district.index');
    }
    private function save(Request $request, $id = null)
    {
        $validated = $request->validate([
            'name' => 'required',
            'province_id' => 'required|exists:province,id'
        ]);

        $data = $request->only(['name', 'province_id']);
        if($id) {
            $dis = District::find($id);
        }
        if ($id) {
            $dis->update($data);
        } else {
            $dis = District::create($data);
        }

    }






    // public function delete($id)
    // {
    //     $user = UserModel::find($id);


    //     if ($user->image) {
    //         if (Storage::disk('public')->exists($user->image)) {
    //         Storage::disk('public')->delete($user->image);
    //         }

    //         $dir = dirname($user->image);
    //         if ($dir !== '.' && $dir !== '') {
    //         $files = Storage::disk('public')->files($dir);
    //         $subdirs = Storage::disk('public')->allDirectories($dir);
    //         if (empty($files) && empty($subdirs)) {
    //             Storage::disk('public')->deleteDirectory($dir);
    //         }
    //         }
    //     }

    //     $user->delete();
    //     return redirect()->route('user.index');
    // }
}
