<?php

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Illuminate\Support\Facades\DB;

// Find Kampong Thom province (កំពង់ធំ)
$province = DB::table('province')
    ->where('name', 'LIKE', '%កំពង់ធំ%')
    ->first();

if (!$province) {
    die("Error: Kampong Thom province not found in the database.\n");
}

echo "=== Adding Districts to {$province->name} ===\n";

// Check if Tang Kouk district already exists
$tangKoukExists = DB::table('district')
    ->where('province_id', $province->id)
    ->where('name', 'តាំងគោក')
    ->exists();

if ($tangKoukExists) {
    echo "✅ 'តាំងគោក' district already exists in {$province->name}.\n";
} else {
    // Get the next available ID for the district
    $nextId = DB::table('district')->max('id') + 1;
    
    // Add Tang Kouk district
    DB::table('district')->insert([
        'id' => $nextId,
        'province_id' => $province->id,
        'name' => 'តាំងគោក',
        'created_at' => now(),
        'updated_at' => now(),
    ]);
    
    echo "✅ Successfully added 'តាំងគោក' district to {$province->name} with ID: {$nextId}\n";
}

// List all districts in Kampong Thom after update
echo "\n=== Current Districts in {$province->name} ===\n";

$districts = DB::table('district')
    ->where('province_id', $province->id)
    ->orderBy('name')
    ->get();

foreach ($districts as $district) {
    echo "- {$district->name} (ID: {$district->id})\n";
}

echo "\n=== Update Complete ===\n";
